/* ************************************************************************* *
 *                                                                           *
 *    pfsd_iodone.c,v
 *    pfsd procedures to check the termination of an IO operation
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_iodone.c,v
 *  RCS Date     : 1996/04/24 14:30:12
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_iodone.c,v 1.1 1996/04/24 14:30:12 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int _checkfh _PH((pfslib_fhdl fh, struct svc_req *rqstp));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Return whether an IO operation terminated                                 *
 * ************************************************************************* */
ioopres *pfsd_iodone_1
#ifdef ANSI_C
(ioidstatargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
ioidstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static ioopres  result;

  int _ftix = argp->fh.vfd;     /* File table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID = argp->ioID;       /* Id table index */

  /*
  xdr_free(xdr_iodoneres, (char *)&result);
  */

  /*
   * check pfslib_fhdl     
   */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(ioopres_u, errno);
    return (&result);
  }

  /*
   * check the rest of the input arguments
   */

  if ((_ioID < 0) || ( _ioID >= MAXIOID ) || 
      (_IOID.state == ID_UNUSED))
  {
    ERR_MACRO(ioopres_u, EPFSLBADID);
    return(&result);
  }

  /* LAMBO iodone sollte nie synchronisieren  */

  result.stat = RPC_OK;
  
  if (_IOID.state == ID_DONE)
  {
    /* The ioop is complete */
    result.ioopres_u.res.done  = TRUE;
    result.ioopres_u.res.res   = _IOID.res;
    result.ioopres_u.res.errno = _IOID.errno;

    _IOID.state = ID_UNUSED;
  }
  else
  {
    /* The ioop is not complete */
    result.ioopres_u.res.done = FALSE;
  }

  return (&result);
}
