/* ************************************************************************* *
 *                                                                           *
 *    pfsd_getioid.c,v
 *    pfsd procedures to obtain an IO identifier
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_getioid.c,v
 *  RCS Date     : 1996/05/29 15:36:46
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_getioid.c,v 1.2 1996/05/29 15:36:46 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _checkfh          _PH((pfslib_fhdl fh, struct svc_req *rqstp));
extern void set_offset_unix   _PH((int _ftix, int _ctix, int _ioID));
extern void set_offset_log    _PH((int _ftix, int _ctix, int _ioID));
extern void set_offset_record _PH((int _ftix, int _ctix, int _ioID));
extern void set_offset_global _PH((int _ftix, int _ctix, int _ioID));
extern void set_offset_sync   _PH((int _ftix, int _ctix, int _ioID));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Return new IO identifier                                                  *
 * ************************************************************************* */
getioidres *pfsd_getioid_1
#ifdef ANSI_C
(getioidargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
getioidargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static getioidres result;
  
  int _ftix = argp->fh.vfd;     /* file table index */
  int _ctix = argp->fh.which;   /* Client table index */
  int _ioID;                    /* Id table index */

  /*
   * xdr_free(xdr_getioidres, (char *)&result);
   */

  /*
   * check pfslib_fhdl     
   */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(getioidres_u, errno);
    return(&result);
  }

  switch (argp->op)
  {
  case READ_OP:
  case READV_OP:
  case WRITE_OP:
  case WRITEV_OP:
    break;
  default:
    ERR_MACRO(getioidres_u, EPFSLINVAL);
    return (&result);
  }

  /* get the next free ioid */
  for (_ioID=0; _ioID<MAXIOID; _ioID++)
  {
    if (_IOID.state == ID_UNUSED)
      break;
  }

  if (_ioID >= MAXIOID)
  {
    /* No more unused ioids */
    ERR_MACRO(getioidres_u, EPFSLMREQUEST);
    return(&result);
  }

  /* Set default values of ioid table element */

  _IOID.state  = ID_ALLOC;
  _IOID.mode   = _CFTE.mode;
  _IOID.ioseq  = _CLNT.ioseq++; /* Sequence number */
  _IOID.oldmode = FALSE;
  
  _IOID.errno  = 0;
  _IOID.iowait = FALSE;
  _IOID.mixio  = FALSE;
  _IOID.op     = argp->op;
  _IOID.offset = -1;
  _IOID.iolen  = argp->iolen;

  /* Set the file offset for the operation */
  switch (_IOID.mode)
  {
  case M_UNIX:
    set_offset_unix(_ftix,_ctix,_ioID);
    break;
    
  case M_LOG:
    set_offset_log(_ftix,_ctix,_ioID);
    break;

  case M_RECORD:
    set_offset_record(_ftix,_ctix,_ioID);
    break;

  case M_GLOBAL:
    set_offset_global(_ftix,_ctix,_ioID);
    break;

  case M_SYNC:
    set_offset_sync(_ftix,_ctix,_ioID);
    break;

  default:
    /* LAMBO Fehler */
    break;
  }

  result.getioidres_u.ioID = _ioID;
  
  return(&result);
}
