/* ************************************************************************* *
 *                                                                           *
 *    pfsd_getdist.c,v
 *    pfsd procedures to obtain distribution information
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_getdist.c,v
 *  RCS Date     : 1996/05/29 15:36:44
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Norman Thomson                                 *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_getdist.c,v 1.3 1996/05/29 15:36:44 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int       _checkfh       _PH((pfslib_fhdl fh, struct svc_req *rqstp));
extern DIST_LIST _dist_get_list _PH((int _ftix, int _ctix, int _ioID));
void             _dist_del_list _PH((DIST_LIST list));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Return a distribution list for an IO identifier                           *
 * ************************************************************************* */
getdistres *pfsd_getdist_1
#ifdef ANSI_C
(ioidstatargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
ioidstatargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static getdistres result;
  
  int _ftix = argp->fh.vfd;     /* file table index */
  int _ctix = argp->fh.which;   /* Client table index */

  int _ioID = argp->ioID;
  
  /*
   * check pfslib_fhdl     
   */

  if (_checkfh(argp->fh,rqstp) < 0 )
  {
    ERR_MACRO(getdistres_u, errno);
    return(&result);
  }

  switch (_IOID.op)
  {
  case READ_OP:
  case READV_OP:
  case WRITE_OP:
  case WRITEV_OP:
    break;
  default:
    ERR_MACRO(getdistres_u, EPFSLINVAL);
    return (&result);
  }

  result.getdistres_u.res.oflags = ((_CFTE.oflags &
                                     (~(O_APPEND|O_EXCL|O_TRUNC))) |
                                    O_CREAT);
  result.getdistres_u.res.perm = _CFTE.permission;

  /* Set the file offset for the operation */
  switch (_IOID.mode)
  {
  case M_UNIX:
  case M_LOG:
  case M_RECORD:
    if (_IOID.state == ID_OFSSET)
    {
      result.stat = RPC_OK;
      result.getdistres_u.res.list = _dist_get_list(_ftix,_ctix,_ioID);
      _IOID.state = ID_DISTDONE;
    }
    else
    {
      ERR_MACRO(getdistres_u, EPFSLINVAL);
    }
    break;
    
  case M_SYNC:
    if (_IOID.state == ID_OFSSET)
    {
      if (_IOID.mixio)
      {
        ERR_MACRO(getdistres_u, EPFSLMIXIO);
      }
      else
      {
        result.stat = RPC_OK;
        result.getdistres_u.res.list = _dist_get_list(_ftix,_ctix,_ioID);
      }
      _IOID.state = ID_DISTDONE;
    }
    else if (_IOID.state == ID_ALLOC)
    {
      _IOID.transp = rqstp->rq_xprt;
      _IOID.state = ID_DISTPEND;
      return(NULL);             /* Delayed reply */
    }
    else
    {
      ERR_MACRO(getdistres_u, EPFSLINVAL);
    }
    break;

  case M_GLOBAL:
    if (_IOID.state == ID_OFSSET)
    {
      if (_IOID.mixio)
      {
        ERR_MACRO(getdistres_u, EPFSLMIXIO);
      }
      else
      {
        result.stat = RPC_OK;
        switch (_IOID.op)
        {
        case WRITE_OP:
        case WRITEV_OP:
          if (_ctix == 0)
            result.getdistres_u.res.list = _dist_get_list(_ftix,_ctix,_ioID);
          else
          {
            result.getdistres_u.res.list.DIST_LIST_len = 0;
            result.getdistres_u.res.list.DIST_LIST_val = NULL;
          }
          break;
        case READ_OP:
        case READV_OP:
          result.getdistres_u.res.list = _dist_get_list(_ftix,_ctix,_ioID);
          break;
        }
      }
      _IOID.state = ID_DISTDONE;
    }
    else if (_IOID.state == ID_ALLOC)
    {
      _IOID.transp = rqstp->rq_xprt;
      _IOID.state = ID_DISTPEND;
      return(NULL);             /* Delayed reply */
    }
    else
    {
      ERR_MACRO(getdistres_u, EPFSLINVAL);
    }
    break;


  default:
    /* LAMBO Fehler */
    break;
  }
  
  if (!svc_sendreply(rqstp->rq_xprt, xdr_getdistres, (char *)&result))
  {
    svcerr_systemerr(rqstp->rq_xprt);
  }

  if (result.stat == RPC_OK)
    _dist_del_list(result.getdistres_u.res.list);
  
  return(NULL);
}
