/* ************************************************************************* *
 *                                                                           *
 *    pfsd_exit.c,v
 *    pfsd procedures to terminate a pfsd process
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_exit.c,v
 *  RCS Date     : 1996/12/27 15:47:08
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_exit.c,v 1.5 1996/12/27 15:47:08 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>

#include "global.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _iod_exit   _PH((void));
extern int  _iod_signal _PH((int sig));
extern void unregister  _PH((void));
extern int  _dist_del   _PH((int _ftix));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Exit an pfsd program.                                                     *
 * ************************************************************************* */
void *pfsd_exit_1
#ifdef ANSI_C
(void *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
void *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static char result;
  int _ftix;

  fprintf(stdout,"pfsd: pfsd_exit_1(): start exiting\n");
  fflush(stdout);

  /* Save open files */
  for (_ftix=0; _ftix<MAXNUMFILES; _ftix++)
  {
    if (_CFTE.actual > 0)
    {
      _dist_del(_ftix);
      free(_CFTE.cltab);
      _CFTE.cltab = (CltTabEl *)0;
      _CFTE.actual = 0;
    }
  }
  
  _iod_exit();

  _iod_signal(SIGTERM);

  svc_sendreply(rqstp->rq_xprt,xdr_void,&result);

  unregister();

#ifdef DEBUG
  fprintf(stdout,"pfsd: pfsd_exit_1(): exiting\n");
#endif /* DEBUG */

  _exit(0);                     /* Don't send an exit to the iod processes
                                 * again. Hence, call _exit() instead of
                                 * exit(); */
}
