/* ************************************************************************* *
 *                                                                           *
 *    pfsd_defines.h,v
 *    pfsd specific definitions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_defines.h,v
 *  RCS Date     : 1996/12/27 15:47:04
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef __pfslib_pfsd_defines_h__
#define __pfslib_pfsd_defines_h__

#ifndef lint
static void *rcs_id_pfsd_defines_h = "pfsd_defines.h,v 1.3 1996/12/27 15:47:04 lamberts V2_0_B";
#endif


/* ************************************************************************* *
 * Defintions
 * ************************************************************************* */

#define MAXNUMFILES     64      /* == (getdtablesize()/4) */
#define MAXNUMCLIENTS  128      /* == (getdtablesize()/2) */
#define MAXIOID         20      /* numer of io identifiers per client
                                   per file */

/* ************************************************************************* *
 * Type definitions                                                          *
 * ************************************************************************* */

/* ************************************************************************* *
 * States of IO identifiers                                                  *
 * ************************************************************************* */
typedef enum
{
  ID_UNUSED,                    /* Not in use */
  ID_ALLOC,                     /* The I/O Id is allocated
                                 * The operation must not be performed yet
                                 * there is still some information missing */
  ID_OFSSET,                    /* The ofset for the operation is set
                                 * but the client didn't request the
                                 * distribution yet */
  ID_DISTPEND,                  /* As ID_ALLOC;
                                 * The client requested the distribution
                                 * but the request could not yet be answered */
  ID_DISTDONE,                  /* The distribution information was sent */
  ID_DONE                       /* The operation was done successfuly */
} ID_state;


/* ************************************************************************* *
 * Element of the IO identifier table                                        *
 * ************************************************************************* */
struct IdTabEl {
  ID_state      state;          /* State of this ioID */

  unsigned long ioseq;          /* Sequence number */
  int           mode;           /* Mode of this operation */
  bool_t        oldmode;        /* This idID was not released before a
                                   setiomode call */
  long          res;            /* Number of bytes transmitted
                                   if res < 0 an error occured and errno is
                                   set to the error on the client's machine */
  int           errno;          /* If state is ID_FAILED errno contains 
                                   the error number of the error */
  bool_t       iowait;          /* If TRUE iowait call is waiting */
  bool_t        mixio;          /* TRUE if error in input parameters in
                                   mode M_GLOBAL or M_SYNC */
  int           op;             /* What kind of operation has to be done */
  long          offset;         /* Offset in the file for the operation */
  long          iolen;          /* Number of bytes to be transfrered */
  SVCXPRT      *transp;         /* Transport for pending IO operations */
};

typedef struct IdTabEl IdTabEl;

typedef IdTabEl IdTable[MAXIOID];

/* ************************************************************************* *
 * Structure specifying a client                                             *
 * ************************************************************************* */
struct clntident
{
  char   hname[MAXNLEN];        /* Hostname of client */
  char   ipaddr[IPADDRLEN];     /* Ipaddr of client */
  int    uid;                   /* Userid of client */
  int    gid;                   /* Groupid of client */
  int    pid;                   /* Process id of client */
  u_long aup_time;              /* Time of authenifiaction information */
};
typedef struct clntident clntident;


/* ************************************************************************* *
 * Element of the client table                                               *
 * ************************************************************************* */
struct CltTabEl {
  bool_t      access;           /* TRUE if the client has access to the file */
  long        foffs;            /* offset in the file if filepointers are
                                   independent */
  long        endoffs;          /* End of file for this process
                                   Used in M_RECORD */
  bool_t      syncdone;         /* TRUE if the client already called a
                                   synchronizing operation */
  bool_t      syncok;           /* TRUE if no error occured during the
                                   execution of a synchronizing operation
                                   by the client  */
  int         syncerr;          /* errno of the error if syncok == FALSE */
  SVCXPRT     *transp;
  /* Authentification parameter */
  clntident   ident;

  unsigned long ioseq;          /* Sequence nuber of ioID */
  
  IdTable     ioIDs;            /* Table of io identifiers */
};
typedef struct CltTabEl CltTabEl;

/* ************************************************************************* *
 * Synchronizing operations                                                  *
 * ************************************************************************* */
typedef enum
{
  PFSD_SYNC_NONE,
  PFSD_SYNC_OPEN,
  PFSD_SYNC_CLOSE,
  PFSD_SYNC_SETIOMODE,
  PFSD_SYNC_LSEEK
} syncop;

/* ************************************************************************* *
 * Filetable                                                                 *
 * ************************************************************************* */
struct filetabel {
  u_int    oflags;              /* passed openflags */
  mode_t   permission;          /* file creation permissions */
  uid_t    uid;                 /* Unix user id */
  gid_t    gid;                 /* Unix group id */
  char     filename[MAXNLEN];   /* real filename */
  int      mode;                /* current iomode */
  int      rqmode;              /* iomode requested in setiomode() */
  long     shoffs;              /* offset in the file if filepointer is
                                   shared */
  long     endoffs;             /* End of file offset */
  int      how_many;            /* number of clients */
  int      actual;              /* accessing the file */
  syncop   sync;                /* controlling flag for synchronisation */
  CltTabEl *cltab;              /* pointer to clienttable */
  caddr_t  distd;               /* Opaque pointer to something defining the
                                   distribution */
};
typedef struct filetabel filetabel;

#endif /* __pfslib_pfsd_defines_h__ */
