/* ************************************************************************* *
 *                                                                           *
 *    pfsd_cltexit.c,v
 *    pfsd procedures for unexpected client termination
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_cltexit.c,v
 *  RCS Date     : 1996/12/27 15:47:02
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_cltexit.c,v 1.6 1996/12/27 15:47:02 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _checkfh    _PH((pfslib_fhdl fh, struct svc_req *rqstp));
extern int  _dist_del   _PH((int _ftix));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Handle unexpected exits of clients                                        *
 * ************************************************************************* */
void *pfsd_cltexit_1
#ifdef ANSI_C
(pfslib_fhdl *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
pfslib_fhdl *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static char result = 0;
  
  int _ftix;
  int _ctix = argp->which;
  
  struct authunix_parms *unix_cred;

  switch (rqstp->rq_cred.oa_flavor)
  {
  case AUTH_UNIX:
    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    break;
  default:
    return (&result);
  }

#ifdef DEBUG
  fprintf(stdout,"pfsd: pfsd_cltexit_1(): received exit msg form %d\n",
          argp->which);
#endif /* DEBUG */

  for (_ftix = 0; _ftix < MAXNUMFILES; _ftix++)
  {
    if ((_CFTE.actual > 0) &&
        (_CFTE.how_many == argp->how_many) &&
        (_CLNT.access) &&
        (_CLNT.ident.pid == argp->pid) &&
        (_CLNT.ident.uid == unix_cred->aup_uid) &&
        (_CLNT.ident.gid == unix_cred->aup_gid) &&
        (_CLNT.ident.aup_time == unix_cred->aup_time) &&
        (strcmp(_CLNT.ident.hname, unix_cred->aup_machname) == 0))
    {
      _CLNT.access = FALSE;
      _CFTE.actual--;

      if (_CFTE.actual == 0)
      {
        (void)_dist_del(_ftix);
        free(_CFTE.cltab);
        _CFTE.cltab = NULL;
      }
    }
  }

  return(&result);
}
