/* ************************************************************************* *
 *                                                                           *
 *    pfsd_close.c,v
 *    pfsd procedures to close a PFSlib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_close.c,v
 *  RCS Date     : 1996/12/27 15:47:01
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_close.c,v 1.3 1996/12/27 15:47:01 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _checkfh    _PH((pfslib_fhdl fh, struct svc_req *rqstp));
extern int  _dist_del   _PH((int _ftix));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Close a PFSLib file                                                       *
 * ************************************************************************* */
errorres *pfsd_close_1
#ifdef ANSI_C
(pfslib_fhdl *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
pfslib_fhdl *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  static errorres  result;      /* reply to client */

  int _ftix = argp->vfd;        /* File table index */
  int _ctix = argp->which;      /* Client table index */
  
  bool_t all_done;
  int _clc;
  

  /*
  (void)xdr_free(xdr_errorres, (char *)&result);
  */

  /*
   * check the pfslib_fhdl 
   */

  if (_checkfh(*argp,rqstp) < 0 )
  {
    ERR_MACRO(errorres_u,errno);
    return (&result);
  }

  /* LAMBO wait for asynchronous io operations to finish */

  _CLNT.access = FALSE;
  _CFTE.actual--;

  switch (_CFTE.mode)
  {
  case M_UNIX:
    if (_CFTE.actual == 0)
    {
      if (_dist_del(_ftix) < 0)
      {
        ERR_MACRO(errorres_u,errno);
      }
      else 
        result.stat = RPC_OK;

      /* Reset client table */
      free(_CFTE.cltab);
      _CFTE.cltab = (CltTabEl *)0;
      _CFTE.actual = 0;
    }
    else 
      result.stat = RPC_OK;
    break;
  case M_LOG:
  case M_RECORD:
  case M_SYNC:
  case M_GLOBAL:
    switch (_CFTE.sync)
    {
    case PFSD_SYNC_NONE:         /* first of global operation */
      /* ******************************************************************* *
       * Initialize a synchorizing operation                                 *
       * ******************************************************************* */
      for (_clc = 0; _clc < _CFTE.how_many; _clc++)
      {
        _CNCL.syncdone = FALSE;
        _CNCL.syncok = TRUE;
        _CNCL.syncerr = 0;
      }
      
      _CFTE.sync     = PFSD_SYNC_CLOSE;

    case PFSD_SYNC_CLOSE:
      _CLNT.syncdone = TRUE;
      _CLNT.transp   = rqstp->rq_xprt;

      all_done = TRUE;
      for (_clc=0; _clc < _CFTE.how_many; _clc++)
      {
        if (!_CNCL.syncdone)
        {
          all_done = FALSE;
          break;
        }
      }

      if (all_done)
      {
        if (_dist_del(_ftix) < 0)
        {
          ERR_MACRO(errorres_u,errno);
        }
        else 
          result.stat = RPC_OK;

        /* Send reply */
        for (_clc=0; _clc < _CFTE.how_many; _clc++)
        {
          if (!svc_sendreply(_CNCL.transp, xdr_errorres, (char *)&result))
          {
            svcerr_systemerr(_CNCL.transp);
          }
        }

        /* Reset file table */
        free(_CFTE.cltab);
        _CFTE.cltab = (CltTabEl *)0;
        _CFTE.actual = 0;
      }
      return ((errorres *)0);   /* Reply was sent or delay reply */

    default:
      fprintf(stderr,"pfsd: pfsd_close_1(): MISMATCHED SYNCHRONISING OPERATIONS");
      ERR_MACRO(errorres_u,EPFSLMIXIO);
    }
  default:
    /* LAMBO Fehler */
    break;
  }  

  return(&result);
}
