/* ************************************************************************* *
 *                                                                           *
 *    pfsd_chkfh.c,v
 *    pfsd procedures to check a file handle
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_chkfh.c,v
 *  RCS Date     : 1996/12/27 15:46:59
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsd_chkfh.c,v 1.3 1996/12/27 15:46:59 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern filetabel *_cftbl;

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Check a filehandle and access permissions                                 *
 * ************************************************************************* */
int _checkfh
#ifdef ANSI_C
(pfslib_fhdl fh, struct svc_req *rqstp)
#else  /* ANSI_C */
(fh, rqstp)
pfslib_fhdl fh;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

  int _ftix = fh.vfd;
  int _ctix = fh.which;

  struct authunix_parms *unix_cred;

  switch (rqstp->rq_cred.oa_flavor)
  {
  case AUTH_UNIX:
    unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    break;
  default:
    errno = EPFSLAUTH;
    return (-1);
  }

  if ((_ftix >= 0) && (_ftix < MAXNUMFILES) && /* Index check */
      (_CFTE.actual > 0) &&          /* element in use */
      (_CFTE.how_many == fh.how_many) && /* correct client count */
      (_CFTE.how_many > _ctix) && /* correct which count */
      (_CLNT.access) &&         /* client has access */
      (_CLNT.ident.pid == fh.pid) && /* correct pid */
      (_CLNT.ident.uid == unix_cred->aup_uid) && /* correct uid */
      (_CLNT.ident.gid == unix_cred->aup_gid) && /* correct gid */
      (_CLNT.ident.aup_time == unix_cred->aup_time) && /* correct aup_time */
      (strcmp(_CLNT.ident.hname, /* correct machine name */
              unix_cred->aup_machname) == 0)) 
  {
    return (0);
  }
  
  errno = EPFSLBADFH;
  return(-1);
}

