/* ************************************************************************* *
 *                                                                           *
 *    pfsd_avl.h,v
 *    pfsd AVL tree definitions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsd_avl.h,v
 *  RCS Date     : 1996/04/24 14:29:47
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts                                                 *
 *                                                                           *
 * ************************************************************************* */

#ifndef __pfsd_avl_h__
#define __pfsd_avl_h__
#ifndef lint
static void *rcs_id_pfsd_avl_h = "pfsd_avl.h,v 1.1 1996/04/24 14:29:47 lamberts V2_0_B";
#endif

struct BLATT {
  char       ipaddr[IPADDRLEN];
  char       filename[MAXNLEN];
  off_t      p_nofs;            /* Normalisiertes Offset
                                   Offset in Datei filename auf Maschine
                                   ipaddr berechnet p_ofs = g_ofs - p_nofs */
};
typedef struct BLATT BLATT;

struct AVLBAUM
{
  int             h;            /* H"ohe des Baumes (0 = Blatt) */
  off_t           g_ofs;        /* Offset in global file of this portion */
  off_t           cut;          /* Cut for left and right subtree */
  off_t           g_eop;        /* Highest global offset of this portion */
  struct AVLBAUM  *lc;          /* Lower Corner */
  struct AVLBAUM  *uc;          /* Upper Corner */
  struct AVLBAUM  *lt;          /* Lower Subtree */
  struct AVLBAUM  *ut;          /* Upper Subtree */
  struct AVLBAUM  *nl;          /* Next leaf */
  
  BLATT         leaf;
};
typedef struct AVLBAUM AVLBAUM;
#endif /* !__pfsd_avl_h__ */
