%/* ************************************************************************* *
% *                                                                           *
% *    pfsd.x,v
% *    RPC description file for the pfsd program
% *                                                                           *
% *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
% *                                                                           *
% *    PFSLib (Parallel I/O on workstations)                                  *
% *                                                                           *
% *    PFSLib offers parallel access to files for a parallel application      *
% *    running on a cluster of workstations.                                  *
% *    It is intended but not restricted to be used in message passing        *
% *    applications based on PVM, NXLib, MPI, and other.                      *
% *                                                                           *
% *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
% *                                                                           *
% *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
% *    modify it under the terms of the GNU Library General Public            *
% *    License as published by the Free Software Foundation; either           *
% *    version 2 of the License, or (at your option) any later version.       *
% *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
% *    and/or modify them under the terms of the GNU General Public           *
% *    License as published by the Free Software Foundation; either           *
% *    version 2 of the License, or (at your option) any later version.       *
% *                                                                           *
% *    PFSLib is distributed in the hope that it will be useful,              *
% *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
% *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
% *    Library General Public License and GNU General Public License          *
% *    for more details.                                                      *
% *                                                                           *
% *    You should have received a copy of the GNU Library General Public      *
% *    License and the GNU General Public License along with this             *
% *    library; if not, write to the Free                                     *
% *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
% *                                                                           *
% *    Contact to the authors:                                                *
% *                                                                           *
% *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
% *                                                                           *
% *    paper mail:      Prof. Dr. A. Bode                                     *
% *                     Lehrstuhl f"ur Rechnertechnik und                     *
% *                     Rechnerorganisation                                   *
% *                     Institut f"ur Informatik                              *
% *                     Technische Universit"at M"unchen                      *
% *                     80290 M"unchen                                        *
% *                     Germany                                               *
% *                                                                           *
% *    This project was partially funded by a research grant form Intel       *
% *    Corporation.                                                           *
% *                                                                           *
% * ************************************************************************* */
%
%
%/* ************************************************************************* *
% *                                                                           *
% *  RCS Filename : pfsd.x,v
% *  RCS Date     : 1996/12/27 15:46:56
% *  RCS Revision : 1.3
% *  RCS Author   : lamberts
% *  RCS State    : V2_0_B
% *                                                                           *
% *  Authors: Stefan Lamberts, Christian R"oder                               *
% *                                                                           *
% * ************************************************************************* */
%#ifndef lint
%#ifndef __rcs_id_pfsd_x__
%#define __rcs_id_pfsd_x__
%static void *rcs_id_pfsd_x = "pfsd.x,v 1.3 1996/12/27 15:46:56 lamberts V2_0_B";
%#endif
%#endif
%


/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include "../include/global_rpc.h"

/* ************************************************************************* *
 * Type definitions
 * ************************************************************************* */


struct pfslib_fhdl
{
  int  vfd;
  int  how_many;
  int  which;
  int  mode;
  int  pid;
};

struct pfslib_fattr
{
  int       type;
  int       amode;
  int       nlink;
  int       userid;
  int       groupid;
  long      size;
  long      atime;
  long      mtime;
  long      ctime;
  int       actual;
};

/* ************************************************************************* *
 * Arguments
 * ************************************************************************* */
struct openargs
{
  bool         global;
  string       filename<MAXNLEN>;
  pfslib_otype oflags;
  int          permission;
  int          how_many;
  int          which;
  int          mode;
  int          pid;
};

struct setiomodeargs
{
  pfslib_fhdl   fh;
  int           mode;
};

struct getioidargs
{
  pfslib_fhdl fh;
  int         op;
  long        iolen;
};

struct ioidstatargs
{
  pfslib_fhdl   fh;
  int           ioID; 
};

struct fpmoveargs
{
  pfslib_fhdl   fh;
  int          whence;
  long         offset;
}; 

struct resetargs
{
  string fname<MAXNLEN>;
};


struct prtstatargs
{
  bool   verbose;
  bool   iods;
  string fname<MAXNLEN>;
};

struct ioopdoneargs
{
  pfslib_fhdl fh;
  int         ioID; 
  long        res;
  int         errno;
};

/* ************************************************************************* *
 * Results
 * ************************************************************************* */
union openres switch (int stat)
{
 case RPC_OK:
  pfslib_fhdl  fh;
 case RPC_ERR:
  errorinfo   err;
 default:
  void;
};

union iomoderes switch (int stat)
{
 case RPC_OK:
  int         mode;
 case RPC_ERR:
  errorinfo   err;
 default:
  void;
};

union getioidres switch (int stat)
{
 case RPC_OK:
  int       ioID;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

struct ioopresult
{
  bool   done;
  long   res;
  int    errno;
};

union ioopres switch (int stat)
{
 case RPC_OK:
  ioopresult res;
 case RPC_ERR:
  errorinfo  err;
 default:
  void;
};

struct DIST_LIST_EL
{
  char   ipaddr[IPADDRLEN];
  char   filename[MAXNLEN];
  long   offset;
  long   length;
  bool   done;
};

#ifdef RPC_XDR
%#ifdef NO_XDR_DIST_LIST
%#define xdr_DIST_LIST xdr_DIST_LIST_unused
%#endif /* NO_XDR_DIST_LIST */
#endif

typedef struct DIST_LIST_EL DIST_LIST<>;

#ifdef RPC_XDR
%#ifdef NO_XDR_DIST_LIST
%#undef xdr_DIST_LIST
%#endif /* NO_XDR_DIST_LIST */
#endif

struct DIST_RESULT
{
  DIST_LIST    list;
  pfslib_otype oflags;
  int          perm;
};

union getdistres switch (int stat)
{
 case RPC_OK:
   DIST_RESULT res;
 case RPC_ERR:
   errorinfo err;
 default:
   void;
};

union lsizeres switch ( int stat )
{
 case RPC_OK:
  long      size;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

union iseofres switch (int stat)
{
 case RPC_OK:
  bool      eof;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

union lseekres switch (int stat)
{
 case RPC_OK:
  long         pos;
 case RPC_ERR:
  errorinfo    err;
 default:
  void;
};

union fattrres switch (int stat)
{
 case RPC_OK:
  pfslib_fattr attr;
 case RPC_ERR:
  errorinfo    err;
 default:
  void;
};

union errorres switch(int stat)
{
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

union resetres switch (int stat)
{
 case RPC_OK:
  int  count;                   /* Number of files which were reset */
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};


#ifdef RPC_SVC

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */
%
%#ifdef ANSI_C
%#define _PH(a) a
%#else  /* ANSI_C */
%#define _PH(a) ()
%#endif /* ANSI_C */
%
%extern bool_t pfslib_auth_ok _PH((struct svc_req *rqstp, SVCXPRT *transp));
%extern void   _pfsd_init     _PH((int argc, char **argv));
%static void   svc_main       _PH((int argc, char **argv));
%
%#undef _PH
%
/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Modification of the server main procedure                                 *
 *   Check whether there is another iod running on this machine befor        *
 *   registering                                                             *
 * ************************************************************************* */
%int main
%#ifdef ANSI_C
%(int argc, char **argv)
%#else  /* ANSI_C */
%(argc, argv)
%int argc;
%char **argv;
%#endif /* ANSI_C */
%{
%  char hostname[MAXNLEN];
%  
%  if (gethostname(hostname,MAXNLEN) < 0)
%  {
%    perror("pfsd: main(): gethostname()");
%    exit(1);
%  }
%  
%  if (callrpc(hostname, PFSD, PFSD_VERS, NULLPROC,
%              xdr_void, (char *)NULL, xdr_void, (char *)0) == RPC_SUCCESS)
%  {
%    fprintf(stderr,"%s: main(): There is already a pfsd registered on this machine\n",
%            argv[0]);
%    fprintf(stderr,"%s: main(): Exiting\n",argv[0]);
%    exit(1);
%  }
%
%  svc_main(argc,argv);
%  return (1);
%}
%
/* ************************************************************************* *
 * define main to call the new main procedure                                *
 * ************************************************************************* */
%
%#ifdef ANSI_C
%#define main() static void svc_main(int argc, char **argv)
%#else
%#define main() static void svc_main(argc, argv)\
%int argc;\
%char **argv;
%#endif
%

/* ************************************************************************* *
 * Initialization before calling svc_run                                     *
 * ************************************************************************* */
%
%static int pfsd_svc_run
%#ifdef ANSI_C
%(int argc, char **argv)
%#else  /* ANSI_C */
%(argc, argv)
%int argc;
%char **argv;
%#endif /* ANSI_C */
%{
%  _pfsd_init(argc, argv);
%  svc_run();
%  /* Should never return */
%  exit(1);
%}
%
/* ************************************************************************* *
 * define svc_run to call pfsd_svc_run                                       *
 * ************************************************************************* */
%
%#define svc_run() pfsd_svc_run(argc, argv)  
%
#endif /* RPC_SVC */

/* ************************************************************************* *
 * Program definition                                                        *
 * ************************************************************************* */
program PFSD
{
  version PFSD_VERS
  {
    openres       PFSD_OPEN       (openargs)       =  1;
    errorres      PFSD_SETIOMODE  (setiomodeargs)  =  2;
    iomoderes     PFSD_GETIOMODE  (pfslib_fhdl)    =  3;
    getioidres    PFSD_GETIOID    (getioidargs)    =  4;
    ioopres       PFSD_IODONE     (ioidstatargs)   =  5;
    ioopres       PFSD_IOWAIT     (ioidstatargs)   =  6;
    lsizeres      PFSD_LSIZE      (fpmoveargs)     =  8;
    iseofres      PFSD_ISEOF      (pfslib_fhdl)    =  9;
    lseekres      PFSD_LSEEK      (fpmoveargs)     = 10;
    fattrres      PFSD_GETFATTR   (pfslib_fhdl)    = 11;
    errorres      PFSD_CLOSE      (pfslib_fhdl)    = 12;
    int           PFSD_NUMCLNTS   (void)           = 13;
    int           PFSD_NUMFILES   (void)           = 14;
    resetres      PFSD_RESET      (resetargs)      = 15;
    void          PFSD_CLTEXIT    (pfslib_fhdl)    = 16;
    void          PFSD_PRTSTAT    (prtstatargs)    = 17;
    void          PFSD_EXIT       (void)           = 18;
    getdistres    PFSD_GETDIST    (ioidstatargs)   = 19;
    errorres      PFSD_IOOPDONE   (ioopdoneargs)   = 20;
    errorres      PFSD_UNLINK     (resetargs)      = 30;
  } = 1;
} = 0x399997;

  












