/* ************************************************************************* *
 *                                                                           *
 *    iod_write.c,v
 *    iod procedures to write to a file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : iod_write.c,v
 *  RCS Date     : 1996/05/28 16:05:25
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "iod_write.c,v 1.3 1996/05/28 16:05:25 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include "iod.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Write data to a file contained in the argument                            *
 * ************************************************************************* */
iod_ioopres *iod_write_1
#ifdef ANSI_C
(iod_ioopargs *argp, struct svc_req *rqstp)
#else  /* ANSI_C */
(argp, rqstp)
iod_ioopargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{
  static iod_ioopres result;

  int pid;
  
  int fd;
  off_t ofs;

#ifdef FILE_LOCKING
  struct flock fl;
#endif /* FILE_LOCKING */

  if (argp->length != argp->data.iod_filedata_len)
  {
    fprintf(stderr,"iod: iod_write_1(): Invalid argument");
    ERR_MACRO(iod_ioopres_u,EPFSLINVAL);
    return(&result);
  }

  result.stat = RPC_OK;
  result.iod_ioopres_u.res.data.iod_filedata_len = 0;
  result.iod_ioopres_u.res.data.iod_filedata_val = NULL;

  if (argp->length == 0)
  {
    result.iod_ioopres_u.res.length = 0;
    return (&result);
  }    

  if (argp->length >= argp->thresh)
  {
    if ((pid = fork()) < 0)
    {
      perror("iod: iod_read_1(): fork()");
      ERR_MACRO(iod_ioopres_u,errno);
      return(&result);
    }
    if (pid != 0)
    {
      /* Parent process */
#ifdef DEBUG
      fprintf(stdout,"iod: iod_write_1(): forked process %d\n",pid);
#endif /* DEBUG */
      return (NULL);
    }
  }
      
  if ((fd = open(argp->fn, argp->oflags)) < 0)
  {
    perror("iod: iod_write_1(): open()");
    ERR_MACRO(iod_ioopres_u,errno);
  }
  else if ((ofs = lseek(fd,argp->offset, SEEK_SET)) < 0)
  {
    perror("iod: iod_write_1(): lseek()");
    ERR_MACRO(iod_ioopres_u,errno);
    close(fd);
  }
  else if (ofs != argp->offset)
  {
    fprintf(stderr,"iod: iod_write_1(): Coudn't lseek() to correct position\n");
    ERR_MACRO(iod_ioopres_u,EPFSLSEEK);
    close(fd);
  }
#ifdef FILE_LOCKING
  else 
  {
    fl.l_type   = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start  = argp->offset;
    fl.l_len    = argp->length;

    if (fcntl(fd,F_SETLKW,&fl) < 0)
    {
      perror("iod: iod_write_1(): fcntl(F_WRLCK)");
      ERR_MACRO(iod_ioopres_u,errno);
      close(fd);
    }
  }
#endif /* FILE_LOCKING */

  if (result.stat == RPC_OK)
  {
    if ((result.iod_ioopres_u.res.length =
         write(fd,argp->data.iod_filedata_val,(u_int)argp->length)) < 0)
    {
      perror("iod: iod_write_1(): write()");
      ERR_MACRO(iod_ioopres_u,errno);
      close(fd);
    }
  }
  
#ifdef FILE_LOCKING
  /* No unlocking necessary close() removes all locks */
#endif /* FILE_LOCKING */

  if (result.stat == RPC_OK)
  {
    close(fd);
  }
  
  if (!svc_sendreply(rqstp->rq_xprt, xdr_iod_ioopres, (char *)&result))
  {
    svcerr_systemerr(rqstp->rq_xprt);
  }
    
  if (pid == 0)
  {
    /* Child process */
    _exit(0);
  }

  return (NULL);
}
