/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "iod.h"
/* ************************************************************************* *
 *                                                                           *
 *    iod.x,v
 *    RPC description file for the iod program
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : iod.x,v
 *  RCS Date     : 1996/05/28 16:04:06
 *  RCS Revision : 1.4
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
#ifndef __rcs_id_iod_x__
#define __rcs_id_iod_x__
static void *rcs_id_iod_x = "iod.x,v 1.4 1996/05/28 16:04:06 lamberts V2_0_B";
#endif
#endif


#ifndef lint
#ifndef __rcs_id_global_rcp_h__
#define  __rcs_id_global_rcp_h__
static void *rcs_id_global_rpc_h = "global_rpc.h,v 1.1 1996/04/24 14:28:00 lamberts V2_0_B";
#endif
#endif


#include <signal.h>


#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern bool_t pfslib_auth_ok  _PH((struct svc_req *rqstp, SVCXPRT *transp));
extern void   iod_sockopt     _PH((struct svc_req *rqstp, SVCXPRT *transp));
extern int    iod_init        _PH((int argc, char **argv));
static void   svc_main        _PH((void));

#undef _PH

int main 
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  char hostname[MAXNLEN];
  
  if (gethostname(hostname,MAXNLEN) < 0)
  {
    perror("iod: main(): gethostname()");
    exit(1);
  }
  
  if (callrpc(hostname, IOD, IOD_VERS, NULLPROC,
              xdr_void, NULL, xdr_void, NULL) == RPC_SUCCESS)
  {
    fprintf(stderr,"iod: main(): There is already an iod running on %s\n",hostname);
    exit(1);
  }

  iod_init(argc,argv);

#ifdef DEBUG
  fprintf(stdout,"iod: main(): Started on %s\n",hostname);
#endif /* DEBUG */

  svc_main();
  /* Never to return */
  exit (1);
}


#define main static void svc_main


static void iod_1();

main()
{
	register SVCXPRT *transp;

	(void) pmap_unset(IOD, IOD_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, IOD, IOD_VERS, iod_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (IOD, IOD_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, IOD, IOD_VERS, iod_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (IOD, IOD_VERS, tcp).");
		exit(1);
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}

static void
iod_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		iod_ioopargs iod_read_1_arg;
		iod_ioopargs iod_write_1_arg;
		iod_truncargs iod_trunc_1_arg;
		iod_unlinkargs iod_unlink_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();


/* BEGIN PATCH done by Makefile */
if (!pfslib_auth_ok(rqstp,transp)) return;
iod_sockopt(rqstp,transp);
/* END PATCH */

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case IOD_EXIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) iod_exit_1;
		break;

	case IOD_READ:
		xdr_argument = xdr_iod_ioopargs;
		xdr_result = xdr_iod_ioopres;
		local = (char *(*)()) iod_read_1;
		break;

	case IOD_WRITE:
		xdr_argument = xdr_iod_ioopargs;
		xdr_result = xdr_iod_ioopres;
		local = (char *(*)()) iod_write_1;
		break;

	case IOD_TRUNC:
		xdr_argument = xdr_iod_truncargs;
		xdr_result = xdr_iod_errorres;
		local = (char *(*)()) iod_trunc_1;
		break;

	case IOD_UNLINK:
		xdr_argument = xdr_iod_unlinkargs;
		xdr_result = xdr_iod_errorres;
		local = (char *(*)()) iod_unlink_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);

/* BEGIN PATCH done by Makefile */
/* Send reply only if resul != NULL
* otherwise reply has to be delayed and sent by _do_op()
*/
if (result != NULL) {
if (!svc_sendreply(transp, xdr_result, result)) {
svcerr_systemerr(transp); }}
/* END PATCH */

	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
