/* ************************************************************************* *
 *                                                                           *
 *    iod_sockopt.c,v
 *    iod procedures to set socket options
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : iod_sockopt.c,v
 *  RCS Date     : 1996/10/18 14:45:03
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "iod_sockopt.c,v 1.5 1996/10/18 14:45:03 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/tcp.h>
#include <rpc/rpc.h>

#include "iod.h"
#include "rpc_defaults.h"

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Set socket options for a client socket                                    *
 * ************************************************************************* */
void iod_sockopt(struct svc_req *rqstp, SVCXPRT *transp)
{
  int soopt;
  int sooptlen;
  
#ifndef SUN4SOL2                /* This doesn't work on Solaris due to
                                 * obscure reasons:
                                 * The file descriptor is not a socket
                                 * descriptor. */
  switch (rqstp->rq_proc)
  {
  case IOD_READ:
    sooptlen = sizeof(soopt);
    if (getsockopt(transp->xp_sock,SOL_SOCKET,SO_TYPE,
                   &soopt,&sooptlen) < 0)
    {
      perror("iod: iod_sockopt(): getsockopt()");
      return;
    }

    switch (soopt)
    {
    case SOCK_STREAM:
      /* TCP_NODELAY */
      soopt = 1;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Setting TCP_NODELAY\n");
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,IPPROTO_TCP,TCP_NODELAY,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,IPPROTO_TCP,TCPNO_DELAY,..)");

      /* Set Buffersize */
      soopt = RPC_TCP_BUFSZ;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Settint SO_SNDBUF to %d\n",soopt);
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,SOL_SOCKET,SO_SNDBUF,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,SOL_SOCKET,SO_SNDBUF,..)");

      /* No break by intention */

    case SOCK_DGRAM:
      /* Set REUSEADDR */
      soopt = 1;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Setting SO_REUSEADDR\n");
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,SOL_SOCKET,SO_REUSEADDR,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,SOL_SOCKET,SO_REUSEADDR,..)");
      break;

    default:
      fprintf(stderr,"iod: iod_sockopt(): Unknown SO_TYPE %d\n",soopt);
      break;
    }
    break;
  case IOD_WRITE:
    sooptlen = sizeof(soopt);
    if (getsockopt(transp->xp_sock,SOL_SOCKET,SO_TYPE,
                   &soopt,&sooptlen) < 0)
    {
      perror("iod: iod_sockopt(): getsockopt()");
      return;
    }
  
    switch (soopt)
    {
    case SOCK_STREAM:
      /* TCP_NODELAY */
      soopt = 1;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Setting TCP_NODELAY\n");
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,IPPROTO_TCP,TCP_NODELAY,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,IPPROTO_TCP,TCPNO_DELAY,..)");

      /* Set Buffersize */
      soopt = RPC_TCP_BUFSZ;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Settint SO_RCVBUF to %d\n", soopt);
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,SOL_SOCKET,SO_RCVBUF,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,SOL_SOCKET,SO_RCVBUF,..)");

      /* No break by intention */

    case SOCK_DGRAM:
      /* Set REUSEADDR */
      soopt = 1;
#ifdef DEBUG
      fprintf(stdout,"iod: iod_sockopt(): Setting SO_REUSEADDR\n");
#endif /* DEBUG */
      if (setsockopt(transp->xp_sock,SOL_SOCKET,SO_REUSEADDR,
                     (char *)&soopt,sizeof(soopt)) < 0)
        perror("iod: iod_sockopt(): setsockopt(..,SOL_SOCKET,SO_REUSEADDR,..)");

      break;

    default:
      fprintf(stderr,"iod: iod_sockopt(): Unknown SO_TYPE %d\n",soopt);
      break;
    }
    break;
  default:
#ifdef DEBUG
    fprintf(stdout,"iod: iod_sockopt(): No Socket option set for this RPC\n");
#endif /* DEBUG */
    break;
  }
#endif /* !SUN4SOL2 */
  return;
}


