/* ************************************************************************* *
 *                                                                           *
 *    iod_init.c,v
 *    iod procedures to initialize iod processes
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : iod_init.c,v
 *  RCS Date     : 1996/06/09 12:34:45
 *  RCS Revision : 1.4
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts                                                 *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "iod_init.c,v 1.4 1996/06/09 12:34:45 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/resource.h>
#include <errno.h>
#include <fcntl.h>

#include "global.h"
#include "iod.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int    iod_init_signal _PH((void));

#undef _PH

/* ************************************************************************* *
 * Global declarations                                                       *
 * ************************************************************************* */

pid_t iodpid;

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Unregister at the portmapper                                              *
 * ************************************************************************* */
void unregister
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{

  if (iodpid == getpid())
  {

#ifdef DEBUG
    fprintf(stdout,"iod: unregister(): unregistering at portmapper\n");
#endif /* DEBUG */

    svc_unregister(IOD,IOD_VERS);
  }
}  

/* ************************************************************************* *
 * Print exit message                                                        *
 * ************************************************************************* */
void exitmsg
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  if (iodpid == getpid())
    fprintf(stdout,"iod: exitmsg(): pid %d exiting\n",getpid());
  else
  {
#ifdef DEBUG
    fprintf(stdout,"iod: exitmsg(): pid %d exiting\n",getpid());
#endif /* DEBUG */
  }
}  

/* ************************************************************************* *
 * Initialize iod                                                            *
 * ************************************************************************* */
void iod_init
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  
  char hostname[MAXNLEN];
  
#ifndef RS6K
  struct rlimit fd_limit, fd_curlim;
#endif /* ! RS6K */

#ifdef IODBG
  int fd;
  pid_t chpid;
  char filename[1024];
#endif /* IODBG */

#ifndef RS6K
  if (getrlimit(RLIMIT_NOFILE, &fd_curlim) < 0 )
  {
    perror("pfsd: _pfsd_init(): getrlimit()");
    exit(1);
  }

  /* set number of filedescriptors to maximum posible */

  fd_limit.rlim_cur = fd_curlim.rlim_max;
  fd_limit.rlim_max = fd_curlim.rlim_max;

  if (setrlimit(RLIMIT_NOFILE,&fd_limit) < 0 )
  {
    perror("pfsd: _pfsd_init(): setrlimit()");
    exit(1);
  }
#endif /* ! RS6K */

#ifdef IODBG
  
  if (gethostname(hostname,MAXNLEN) < 0)
  {
    perror("iod: iod_init(): gethostname()");
    exit(1);
  }

  /* Attach stdout and stderr to a logfile */
  strcpy(filename,IODLOGFILE);
  strcat(filename,".");
  strcat(filename,hostname);

  /* Reopen stdout */
  if (freopen(filename,"a",stdout) == NULL)
  {
    perror("iod: iod_init(): freopen(stdout)");
    exit(1);
  }

  if (fileno(stdout) != 1)
  {
    fprintf(stderr,"iod: iod_init(): freopen(stdout) didn't open descriptor 1\n");
    exit(1);
  }

  /* Reopen stderr */
  if (freopen(filename,"a",stderr) == NULL)
  {
    perror("iod: iod_init(): freopen(stderr)");
    exit(1);
  }
  
  if (fileno(stderr) != 2)
  {
    fprintf(stderr,"iod: iod_init(): freopen(stderr) didn't open descriptor 2\n");
    exit(1);
  }

  /* Don't buffer stdout and stderr  */
  if (setvbuf(stdout,NULL,_IOLBF,BUFSIZ) != 0)
  {
    perror("iod: iod_init(): setvbuf(stdout)");
    exit(1);
  }

  if (setvbuf(stderr,NULL,_IOLBF,BUFSIZ) != 0)
  {
    perror("iod: iod_init(): setvbuf(stderr)");
    exit(1);
  }

  /* Write trough stdout and stderr */
  if (fcntl(fileno(stdout),F_SETFL,O_SYNC) == -1)
  {
    perror("iod: iod_init(): fcntl(stdout)");
    exit(1);
  }

  if (fcntl(fileno(stdin),F_SETFL,O_SYNC) == -1)
  {
    perror("iod: iod_init(): fcntl(stderr)");
    exit(1);
  }

  /* Close all files but stdout and stderr */
  close (0);
#ifndef RS6K
  for (fd = 3; fd < fd_curlim.rlim_cur ; fd++)
    close(fd);
#else  /* !RS6K */
  for (fd = 3; fd < OPEN_MAX; fd++)
    close(fd);
#endif /* !RS6K */

  /* Go into background */
  if ((chpid = fork()) < 0)
  {
    perror("iod: iod_init(): fork()");
    exit (1);
  }
  if (chpid > 0)
  {
    exit (0);
  }

  /* Set process group */
  setpgid(0,0);
  
  errno = 0;
#endif /* IODBG */

  iodpid = getpid();

  /* Unregister at portmapper at exit */
#ifdef SUN4
#ifdef IODBG 
  on_exit(exitmsg);
#endif /* IODBG */
  on_exit(unregister);
#else  /* SUN4 */
#ifdef IODBG 
  atexit(exitmsg);
#endif /* IODBG */
  atexit(unregister);
#endif /* SUN4 */

  /* Setup signal handler */
  if (iod_init_signal() < 0)
  {
    perror("iod: iod_init(): iod_init_signal()");
    exit (1);
  }

#ifdef IODBG
  fprintf(stdout,"iod: iod_init(): pid is %d\n",iodpid);
#endif /* IODBG */

#ifdef DEBUG
  fprintf(stdout,"iod: iod_init(): Started on %s\n",hostname);
#endif /* DEBUG */

  fflush(stdout);

  return;
}

