%/* ************************************************************************* *
% *                                                                           *
% *    iod.x,v
% *    RPC description file for the iod program
% *                                                                           *
% *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
% *                                                                           *
% *    PFSLib (Parallel I/O on workstations)                                  *
% *                                                                           *
% *    PFSLib offers parallel access to files for a parallel application      *
% *    running on a cluster of workstations.                                  *
% *    It is intended but not restricted to be used in message passing        *
% *    applications based on PVM, NXLib, MPI, and other.                      *
% *                                                                           *
% *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
% *                                                                           *
% *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
% *    modify it under the terms of the GNU Library General Public            *
% *    License as published by the Free Software Foundation; either           *
% *    version 2 of the License, or (at your option) any later version.       *
% *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
% *    and/or modify them under the terms of the GNU General Public           *
% *    License as published by the Free Software Foundation; either           *
% *    version 2 of the License, or (at your option) any later version.       *
% *                                                                           *
% *    PFSLib is distributed in the hope that it will be useful,              *
% *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
% *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
% *    Library General Public License and GNU General Public License          *
% *    for more details.                                                      *
% *                                                                           *
% *    You should have received a copy of the GNU Library General Public      *
% *    License and the GNU General Public License along with this             *
% *    library; if not, write to the Free                                     *
% *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
% *                                                                           *
% *    Contact to the authors:                                                *
% *                                                                           *
% *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
% *                                                                           *
% *    paper mail:      Prof. Dr. A. Bode                                     *
% *                     Lehrstuhl f"ur Rechnertechnik und                     *
% *                     Rechnerorganisation                                   *
% *                     Institut f"ur Informatik                              *
% *                     Technische Universit"at M"unchen                      *
% *                     80290 M"unchen                                        *
% *                     Germany                                               *
% *                                                                           *
% *    This project was partially funded by a research grant form Intel       *
% *    Corporation.                                                           *
% *                                                                           *
% * ************************************************************************* */
%
%
%/* ************************************************************************* *
% *                                                                           *
% *  RCS Filename : iod.x,v
% *  RCS Date     : 1996/05/28 16:04:06
% *  RCS Revision : 1.4
% *  RCS Author   : lamberts
% *  RCS State    : V2_0_B
% *                                                                           *
% *  Authors: Stefan Lamberts, Christian R"oder                               *
% *                                                                           *
% * ************************************************************************* */
%#ifndef lint
%#ifndef __rcs_id_iod_x__
%#define __rcs_id_iod_x__
%static void *rcs_id_iod_x = "iod.x,v 1.4 1996/05/28 16:04:06 lamberts V2_0_B";
%#endif
%#endif
%

/* ********************************************************************** *
 * define names of xdr routines to avoid confilcts with pfsd_xdr.c        *
 * ********************************************************************** */
#ifdef RPC_XDR
%
%#define xdr_errorinfo xdr_iod_errorinfo
%
#endif /* RPC_XDR */


/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include "../include/global_rpc.h"

/* ************************************************************************* *
 * Type definitions                                                          *
 * ************************************************************************* */

typedef opaque iod_filedata<>;

/* ************************************************************************* *
 * Arguments                                                                 *
 * ************************************************************************* */
struct iod_ioopargs
{
  string       fn<MAXNLEN>;     /* filename to read from or write to */
  pfslib_otype oflags;          /* openflags of the file */
  int          perm;            /* Permission for file creation */
  
  long         offset;          /* offset to seek for filepointer */
  long         length;          /* number of bytes */
  long         thresh;          /* threshold for fork of iod process */
  iod_filedata data;
};

struct iod_truncargs
{
  string fn<MAXNLEN>;           /* filename */
  long   offset;                /* offset */
};

struct iod_unlinkargs
{
  string fn<MAXNLEN>;           /* filename */
};

/* ************************************************************************* *
 * Resultus
 * ************************************************************************* */
struct iod_opres
{
  long         length;          /* numbe rof read or written bytes */
  iod_filedata data;            /* data of read operation */
};

union iod_ioopres switch (int stat)
{
 case RPC_OK:
  iod_opres res;
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

union iod_errorres switch (int stat)
{
 case RPC_ERR:
  errorinfo err;
 default:
  void;
};

/* ************************************************************************* *
 * iod server program
 * ************************************************************************* */
#ifdef RPC_SVC
/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */
%
%#include <signal.h>
%
/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */
%
%#ifdef ANSI_C
%#define _PH(a) a
%#else  /* ANSI_C */
%#define _PH(a) ()
%#endif /* ANSI_C */
%
%extern bool_t pfslib_auth_ok  _PH((struct svc_req *rqstp, SVCXPRT *transp));
%extern void   iod_sockopt     _PH((struct svc_req *rqstp, SVCXPRT *transp));
%extern int    iod_init        _PH((int argc, char **argv));
%static void   svc_main        _PH((void));
%
%#undef _PH
%
/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Modification of the server main procedure                                 *
 *   Check whether there is another iod running on this machine befor        *
 *   registering                                                             *
 * ************************************************************************* */
%int main 
%#ifdef ANSI_C
%(int argc, char **argv)
%#else  /* ANSI_C */
%(argc, argv)
%int argc;
%char **argv;
%#endif /* ANSI_C */
%{
%  char hostname[MAXNLEN];
%  
%  if (gethostname(hostname,MAXNLEN) < 0)
%  {
%    perror("iod: main(): gethostname()");
%    exit(1);
%  }
%  
%  if (callrpc(hostname, IOD, IOD_VERS, NULLPROC,
%              xdr_void, NULL, xdr_void, NULL) == RPC_SUCCESS)
%  {
%    fprintf(stderr,"iod: main(): There is already an iod running on %s\n",hostname);
%    exit(1);
%  }
%
%  iod_init(argc,argv);
%
%#ifdef DEBUG
%  fprintf(stdout,"iod: main(): Started on %s\n",hostname);
%#endif /* DEBUG */
%
%  svc_main();
%  /* Never to return */
%  exit (1);
%}
%
/* ************************************************************************* *
 * define main to call the new main procedure                                *
 * ************************************************************************* */
%
%#define main static void svc_main
%
#endif /* RPC_SVC */


/* ************************************************************************* *
 * Program definition                                                        *
 * ************************************************************************* */
program IOD {
  version IOD_VERS {
    void          IOD_EXIT     (void)            = 1;
    iod_ioopres   IOD_READ     (iod_ioopargs)    = 2;
    iod_ioopres   IOD_WRITE    (iod_ioopargs)    = 3;
    iod_errorres  IOD_TRUNC    (iod_truncargs)   = 4;
    iod_errorres  IOD_UNLINK   (iod_unlinkargs)  = 5;
  } = 1;
} = 0x399999;

