/* ************************************************************************* *
 *                                                                           *
 *    global_rpc.h,v
 *    Global RPC definitions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : global_rpc.h,v
 *  RCS Date     : 1996/04/24 14:28:00
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef __pfslib_global_rpc_h__
#define __pfslib_global_rpc_h__

/* ************************************************************************* *
 * RPC defintions used by iod and pfsd                                       *
 * ************************************************************************* */
%
%#ifndef lint
%#ifndef __rcs_id_global_rcp_h__
%#define  __rcs_id_global_rcp_h__
%static void *rcs_id_global_rpc_h = "global_rpc.h,v 1.1 1996/04/24 14:28:00 lamberts V2_0_B";
%#endif
%#endif
%

#ifdef RPC_HDR
%
/* ************************************************************************* *
 * Additional include file depending on architecture                         *
 * ************************************************************************* */
%
%#ifdef HPPA
%#include <sys/time.h>
%#include <sys/types.h>
%#endif /* HPPA */
%
%#ifdef SUN4
%#include <memory.h>
%#else
%#include <string.h>
%#endif /* SUN4 */
%
/* ************************************************************************* *
 * Include files
 * ************************************************************************* */
%
%#include "global.h"
%
/* ************************************************************************* *
 * Definitions
 * ************************************************************************* */
%
%#define bzero(a,b) memset(a,0,b)
%
/* ************************************************************************* *
 * Macro to set error return values                                          *
 * ************************************************************************* */
%
%#define ERR_MACRO(a,b)\
%result.stat = RPC_ERR;\
%result.a.err.errno = b;\
%result.a.err.errstr = pfslib_geterrstr(b);
%
%/* Flags for open() call */
%bool_t xdr_pfslib_otype();
%
#endif /* RPC_HDR */

/* ************************************************************************* *
 * Type definition
 * ************************************************************************* */

struct errorinfo                 /* errorinfo: structure in case of an error */
{
  int       errno;
  string    errstr<MAXERRLEN>;
};

#endif /* __pfslib_global_rpc_h__ */
