/* ************************************************************************* *
 *                                                                           *
 *    global.h,v
 *    Global definitions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : global.h,v
 *  RCS Date     : 1996/10/18 14:42:47
 *  RCS Revision : 1.4
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef __pfslib_global_h__
#define __pfslib_global_h__

#ifndef lint
static void *rcs_id_global_h = "global.h,v 1.4 1996/10/18 14:42:47 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Definitions                                                               *
 * ************************************************************************* */

/* ************************************************************************* *
 * Full pathname of the rsh command                                          *
 * ************************************************************************* */
#ifdef HPPA
#define RSH_PATH "/usr/bin/remsh"
#endif
#ifdef SGI
#define RSH_PATH "/usr/bsd/rsh"
#endif
#ifdef SUN4
#define RSH_PATH "/usr/ucb/rsh"
#endif
#ifdef SUN4SOL2
#define RSH_PATH "/usr/bin/rsh"
#endif
#ifdef RS6K
#define RSH_PATH "/usr/bin/rsh"
#endif
#ifdef ALPHA_AXP
#define RSH_PATH "/bin/rsh"
#endif
#ifdef LINUX
#define RSH_PATH "/usr/bin/rsh"
#endif

#define RSH_OPTIONS "-n"        /* rsh command options */

/* ************************************************************************* *
 * IO modes.                                                                 *
 * ************************************************************************* */
#define M_UNIX   0
#define M_LOG    1
#define M_RECORD 2
#define M_SYNC   3
#define M_GLOBAL 4

/* ************************************************************************* *
 * lsize operation types                                                     *
 * ************************************************************************* */
#define SIZE_SET 0
#define SIZE_CUR 1
#define SIZE_END 2

/* ************************************************************************* *
 * Length of an IP address in dot notation.                                  *
 * ************************************************************************* */
#define IPADDRLEN 16            /* 255.255.255.255\0 */

/* ************************************************************************* *
 * String lengths.                                                           *
 * ************************************************************************* */
#define MAXNLEN 1024            /* Max length of an arbitrary name */
#define MAXERRLEN  1024         /* Max length of an error message */

/* ************************************************************************* *
 * Definitions for undefined parts of a distributed file.                    *
 * ************************************************************************* */
#define LOCALHOST "127.0.0.1"   /* IP address of the local host */
#define DEV_ZERO  "/dev/zero"   /* File name for an undefined part */

/* ************************************************************************* *
 * File name extension of distribution files                                 *
 * ************************************************************************* */
#define DISTEXT ".pfslib_dist"

/* ************************************************************************* *
 * iod log file name                                                         *
 * ************************************************************************* */
#ifdef IODBG
#define IODLOGFILE "iodlog"
#endif /* IODBG */
 
/* ************************************************************************* *
 * Number of retries to call NULLPROC at a new iod process                   *
 * ************************************************************************* */
#ifdef IODBG
#define IODSTART_RPCRETRY 5
#else  /* IODBG */
#define IODSTART_RPCRETRY 10
#endif /* IODBG */

/* ************************************************************************* *
 * Return codes of RPCs                                                      *
 * ************************************************************************* */
#define RPC_ERR -1              /* RCP returned with an error */
#define RPC_OK  0               /* RCP returned  successfuly */

/* ************************************************************************* *
 * IO operation types                                                        *
 * ************************************************************************* */
#define WRITE_OP  0             /* Write operation */
#define READ_OP   1             /* Read operation */
#define WRITEV_OP 2             /* Write vector operation */
#define READV_OP  3             /* Read vector operation */

/* ************************************************************************* *
 * Machine independent open flags                                            *
 * ************************************************************************* */
#define PFSLIB_O_RDONLY   0x0000
#define PFSLIB_O_WRONLY   0x0001
#define PFSLIB_O_RDWR     0x0002
#define PFSLIB_O_NDELAY   0x0004
#define PFSLIB_O_APPEND   0x0008
#define PFSLIB_O_CREAT    0x0200
#define PFSLIB_O_TRUNC    0x0400
#define PFSLIB_O_EXCL     0x0800
#define PFSLIB_O_SYNC     0x2000
#define PFSLIB_O_NONBLOCK 0x4000
#define PFSLIB_O_NOCTTY   0x8000

typedef int pfslib_otype;

/* ************************************************************************* *
 * Timing Macros                                                             *
 * ************************************************************************* */


#ifdef TIMING
#define S_TIME(a) {\
                     extern double _tm_start_ ## a;\
                     extern double dclock();\
                     _tm_start_ ## a = dclock();\
                 }

#define DKL_TIMER(a) \
extern double _tm_sum_ ## a;\
extern double _tm_sqsum_ ## a;\
extern double _tm_max_ ## a;\
extern double _tm_min_ ## a;\
extern int    _tm_cnt_ ## a;\
extern double _tm_start_ ## a;\
extern double _tm_time_ ## a;
                      
#define E_TIME(a) {\
                     extern double dclock();\
                     DKL_TIMER(a);\
                     _tm_time_ ## a = 1000.0*(dclock() - _tm_start_ ## a);\
                     if (_tm_time_ ## a > _tm_max_ ## a)\
                       _tm_max_ ## a = _tm_time_ ## a;\
                     if ((_tm_min_ ## a == 0.0) ||\
                         (_tm_time_ ## a < _tm_min_ ## a))\
                       _tm_min_ ## a = _tm_time_ ## a;\
                     _tm_sum_ ## a += _tm_time_ ## a;\
                     _tm_sqsum_ ## a += _tm_time_ ## a * _tm_time_ ## a;\
                     _tm_cnt_ ## a++;\
                 }

                     
                      
#else  /* TIMING */
#define S_TIME(a) {}
#define E_TIME(a) {}
#endif /* TIMING */

#endif /* __pfslib_global_h__ */
