/*****************************************************************************
 *                                                                           *
 *  RCS Filename : tst.c,v
 *  RCS Date     : 1996/10/18 14:42:15
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts                                                 *
 *                                                                           *
 *****************************************************************************/

#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <pfslib.h>
#include <errno.h>
#include <sys/types.h>
#ifdef VECTOR
#include <sys/uio.h>
#endif /* VECTOR */
#include <stdlib.h>
#ifdef NXLIB
#include <nx.h>
#endif /* NXLIB */

#ifdef VECTOR
#define USAGE fprintf(stderr,\
"usage: %s\n\
\t[-h pfsdhost]\n\
\t[-n number_of_clients]\n\
\t[-c client_threshold]\n\
\t[-s server_threshold]\n\
\t[-a]\n\
\t[-i iterations]\n\
\t[-l length]\n\
\t[-o {ciw}+]\n\
\t[-m {glrsu}+]\n\
\t[-q]\n\
\t[-v vectorcount]\n",argv[0])
#else  /* VECTOR */
#define USAGE fprintf(stderr,\
"usage: %s\n\
\t[-h pfsdhost]\n\
\t[-n number_of_clients]\n\
\t[-c client_threshold]\n\
\t[-s server_threshold]\n\
\t[-a]\n\
\t[-i iterations]\n\
\t[-l length]\n\
\t[-o {ciw}+]\n\
\t[-m {glrsu}+]\n\
\t[-q]\n",argv[0])
#endif /* VECTOR */

#ifdef VECTOR
#define OPTIONSTRING "akh:n:s:c:i:l:v:m:o:q"
#else  /* VECTOR */
#define OPTIONSTRING "akh:n:s:c:i:l:m:o:q"
#endif /* VECTOR */

#define INPUTFILE "/tmp/inputfile"
#define OUTPUTFILE "/tmp/outputfile"

#define BUFFSIZE 10000

#ifdef VECTOR
#define VECTORCNT 10
#endif /* VECTOR */

#define PERMMODES "glgrgsgulrlslursrusug"
#define PERMOP "ciw"

#ifdef VECTOR
#define IOOP(a) a ## v(fd,iov,vectorcnt)
#define IOOPLEN _vectorlength(iov,vectorcnt)
#else  /* VECTOR */
#define IOOP(a) a(fd,(char *)buffer,len*sizeof(struct DATA))
#define IOOPLEN (len*sizeof(struct DATA))
#endif /* VECTOR */

extern char *optarg;

char *pfsdhost = "ibode1";
int numclnts   = 2;             /* 2 */
int svc_thr    = 0;            /* -1 */
int clt_thr    = 0;             /* 0 */
int iterations = 2;             /* 2 */
int mynum      = 0;             /* 0 */
int length     = 1;             /* 1 */
#ifdef VECTOR
int vectorcnt  = 2;             /* 2 */
#endif /* VECTOR */
int append     = 0;             /* 0 */
int nocheck    = 0;             /* 0 */
int quiet      = 0;             /* 0 */
int success    = 1;             /* 1 */

struct DATA
{
  char mode;
  char iter;
  char node;
#ifdef VECTOR
  char vnum;
#endif
  char field;
  char end;
}
#ifdef VECTOR
buffer [VECTORCNT][BUFFSIZE];
#else  /* VECTOR */
buffer [BUFFSIZE];
#endif /* VECTOR */

#ifdef VECTOR
struct iovec iov[VECTORCNT];
#endif /* VECTOR */

enum optype
{
  N_CWRITE,
  N_CREAD,
  N_IWRITE_IOWAIT,
  N_IREAD_IOWAIT,
  N_IWRITE_N_IOWAIT,
  N_IREAD_N_IOWAIT
};
typedef enum optype optype;

char *opstr
#ifdef ANSI_C
(optype op)
#else
(op)
optype op;
#endif /* ANSI_C */
{
  return (op == N_CWRITE ? "N_CWRITE" :
          op == N_CREAD ? "N_CREAD" :
          op == N_IWRITE_IOWAIT ? "N_IWRITE_IOWAIT" :
          op == N_IREAD_IOWAIT ? "N_IREAD_IOWAIT" :
          op == N_IWRITE_N_IOWAIT ? "N_IWRITE_N_IOWAIT" :
          op == N_IREAD_N_IOWAIT ? "N_IREAD_N_IOWAIT" :
          "UNKNOWN");
}


char *modestr
#ifdef ANSI_C
(int mode)
#else
(mode)
int mode;
#endif
{
  
  return (mode == M_UNIX   ? "M_UNIX"   :
          mode == M_LOG    ? "M_LOG"    :
          mode == M_RECORD ? "M_RECORD" :
          mode == M_SYNC   ? "M_SYNC"   :
          mode == M_GLOBAL ? "M_GLOBAL" :
          "UNKOWN");
}


void set_wr_data
#ifdef ANSI_C
(int mode, int len, int it)
#else
(mode, len, it)
int mode;
int len;
int it;
#endif
{
  int i;
#ifdef VECTOR
  int v;
#endif /* VECTOR */
  char m;

  switch (mode)
  {
  case M_UNIX:
    m = 'U';
    break;
  case M_GLOBAL:
    m = 'G';
    break;
  case M_LOG:
    m = 'L';
    break;
  case M_SYNC:
    m = 'S';
    break;
  case M_RECORD:
    m = 'R';
    break;
  }

#ifdef VECTOR
  for (v=0;v<vectorcnt;v++)
  {
    for (i=0;i<(len+v);i++)
    {
      buffer[v][i].mode = m;
      buffer[v][i].iter = (char)it+'0';
      buffer[v][i].node = (char)mynum+'0';
      buffer[v][i].vnum = (char)v+'0';
      buffer[v][i].field = (char)i+'0';
      if ((v == (vectorcnt - 1)) && (i == (len+v-1)))
        buffer[v][i].end = '\n';
      else if (i == (len+v-1))
        buffer[v][i].end = '^';
      else
        buffer[v][i].end = ' ';
    }
  }
#else  /* VECTOR */
  for (i=0;i<len;i++)
  {
    buffer[i].mode = m;
    buffer[i].iter = (char)it+'0';
    buffer[i].node = (char)mynum+'0';
    buffer[i].field = (char)i+'0';
    if (i < (len-1))
      buffer[i].end = ' ';
    else
      buffer[i].end = '\n';
  }
#endif /* VECTOR */

  return;
}


void test_rd_data
#ifdef ANSI_C
(optype op, int mode, int len, int it)
#else
(op, mode, len, it)
optype op;
int mode;
int len;
int it;
#endif /* ANSI_C */
{
  int i;
#ifdef VECTOR
  int v;
#endif /* VECTOR */
  char mc,ic,nc;
  
  if (nocheck)
    return;

  ic = (char)it+'0';

  switch (mode)
  {
  case M_UNIX:
    mc = 'U';
    nc = ' ';
    break;
  case M_GLOBAL:
    mc = 'G';
    nc = ' ';
    break;
  case M_LOG:
    mc = 'L';
    nc = ' ';
#ifdef VECTOR
    ic = buffer[0][0].iter;
#else  /* VECTOR */
    ic = buffer[0].iter;
#endif /* VECTOR */
    break;
  case M_SYNC:
    mc = 'S';
    nc = (char)mynum+'0';
    break;
  case M_RECORD:
    mc = 'R';
    nc = (char)mynum+'0';
    break;
  }

#ifdef VECTOR
  for (v=0;v<vectorcnt;v++)
  {
    for (i=0;i<(len+v);i++)
      if ((buffer[v][i].mode != mc) ||
          (buffer[v][i].iter != ic) ||
          (buffer[v][i].node != nc) ||
          (buffer[v][i].vnum != ((char)v+'0')) ||
          (buffer[v][i].field != ((char)i+'0')))
      {
        fprintf(stderr,
                "%s %s: In Iter %d Vec %d Elt %d Expected '%c%c%c%c%c' Got '%c%c%c%c%c'\n",
                opstr(op),modestr(mode),it,v,i,
                mc,ic,nc,(char)v+'0',(char)i+'0',
                buffer[v][i].mode,buffer[v][i].iter,
                buffer[v][i].node,buffer[v][i].vnum,buffer[v][i].field);
        success = 0;
      }
  }
#else  /* VECTOR */
  for (i=0;i<len;i++)
    if ((buffer[i].mode != mc) ||
        (buffer[i].iter != ic) ||
        (buffer[i].node != nc) ||
        (buffer[i].field != ((char)i+'0')))
    {
      fprintf(stderr,
              "%s %s: In Iter %d Elt %d Expected '%c%c%c%c' Got '%c%c%c%c'\n",
              opstr(op),modestr(mode),it,i,
              mc,ic,nc,(char)i+'0',
              buffer[i].mode,buffer[i].iter,
              buffer[i].node,buffer[i].field);
      success = 0;
    }
#endif /* VECTOR */
  return;
}


void wr_input
#ifdef ANSI_C
(int fd, int mode)
#else
(fd, mode)
int fd;
int mode;
#endif
{
  int i;
#ifdef VECTOR
  int v;
#endif /* VECTOR */
  int n;
  int it;
  int num;
  int len;
  int iter;
  char mc;
  char nc;
  
  switch (mode)
  {
  case M_UNIX:
    mc = 'U';
    nc = ' ';
    num = 1;
    len = length;
    iter = iterations;
    break;
  case M_GLOBAL:
    mc = 'G';
    nc = ' ';
    num = 1;
    len = length;
    iter = iterations;
    break;
  case M_RECORD:
    mc = 'R';
    num = numclnts;
    len = length;
    iter = iterations;
    break;
  case M_LOG:
    mc = 'L';
    nc = ' ';
    num = 1;
    len = length;
    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    break;
  case M_SYNC:
    mc = 'S';
    num = numclnts;
    iter = iterations;
    break;
  }    

  for (it=0; it<iter;it++)
  {
    for (n=0; n < num; n++)
    {
      switch (mode)
      {
      case M_SYNC:
        len = length+n;
      case M_RECORD:
        nc = (char)n+'0';
      }

#ifdef VECTOR
      for (v=0;v<vectorcnt;v++)
      {
        for (i=0; i<(len+v);i++)
        {
          buffer[0][i].mode = mc;
          buffer[0][i].iter = (char)it+'0';
          buffer[0][i].node = nc;
          buffer[0][i].vnum = (char)v+'0';
          buffer[0][i].field = (char)i+'0';
          if ((v == (vectorcnt - 1)) && (i == (len+v-1)))
            buffer[0][i].end = '\n';
          else if (i == (len+v-1))
            buffer[0][i].end = '^';
          else
            buffer[0][i].end = ' ';
        }
        if (_cwrite(fd,(char *)&buffer[0][0],(len+v)*sizeof(struct DATA))
            != ((len+v)*sizeof(struct DATA)))
        {
          pfslib_perror ("_cwrite()");
          exit (1);
        }
      }
#else  /* VECTOR */
      for (i=0; i<len;i++)
      {
        buffer[i].mode = mc;
        buffer[i].iter = (char)it+'0';
        buffer[i].node = nc;
        buffer[i].field = (char)i+'0';
        if (i < (len-1))
          buffer[i].end = ' ';
        else
          buffer[i].end = '\n';
      }
      
      if (_cwrite(fd,(char *)buffer,len*sizeof(struct DATA))
          != (len*sizeof(struct DATA)))
      {
        pfslib_perror ("_cwrite()");
        exit (1);
      }
#endif /* VECTOR */
    }
  }
  return;
}

void chk_output
#ifdef ANSI_C
(optype op, int fd, int mode)
#else  /* ANSI_C */
(op, fd, mode)
optype op;
int fd;
int mode;
#endif /* ANSI_C */
{
  int i;
#ifdef VECTOR
  int v;
#endif /* VECTOR */
  int n;
  int it;
  int num;
  int len;
  int iter;
  char mc;
  char ncn,ncx;
  char ic;
  
  if (nocheck)
    return;

  switch (mode)
  {
  case M_UNIX:
    mc = 'U';
    ncn = '0';
    ncx = (char)numclnts+'0';
    num = 1;
    len = length;    
    iter = iterations;
    break;
  case M_GLOBAL:
    mc = 'G';
    ncn = '0';
    ncx = '0';
    num = 1;
    len = length;    
    iter = iterations;
    break;
  case M_RECORD:
    mc = 'R';
    num = numclnts;
    len = length;    
    iter = iterations;
    break;
  case M_LOG:
    mc = 'L';
    num = 1;
    len = length;
    iter = (numclnts*iterations)+(((numclnts)*(numclnts-1))/2);
    break;
  case M_SYNC:
    mc = 'S';
    num = numclnts;
    iter = iterations;
    break;
    
  }
  
  for (it=0; it<iter;it++)
  {
    ic = (char)it+'0';
    for (n=0; n < num; n++)
    {
      switch (mode)
      {
      case M_SYNC:
        len = length+n;
      case M_RECORD:
        ncn = (char)n+'0';
        ncx = (char)n+'0';
      }
#ifdef VECTOR
      for (v=0;v<vectorcnt;v++)
      {
        if (_cread(fd,(char *)&buffer[0][0],(len+v)*sizeof(struct DATA))
            != ((len+v)*sizeof(struct DATA)))
          pfslib_perror ("_cread()");
        if (mode == M_LOG)
        {
          ic = buffer[0][0].iter;
          ncn = ncx = buffer[0][0].node;
        }
        for (i=0; i<(len+v);i++)
          if ((buffer[0][i].mode  != mc) ||
              (buffer[0][i].node < ncn) ||
              (buffer[0][i].node > ncx) ||
              (buffer[0][i].iter != ic) ||
              (buffer[0][i].vnum != ((char)v+'0')) ||
              (buffer[0][i].field != ((char)i+'0')))
          {
            fprintf(stderr,
                    "%s %s: In Iter %d Nd %d Vec %d Elt %d Expected '%c%c[%c,%c]%c%c' Got '%c%c%c%c%c'\n",
                    opstr(op),modestr(mode),it,n,v,i,
                    mc,ic,ncn,ncx,(char)v+'0',(char)i+'0',
                    buffer[0][i].mode,buffer[0][i].iter,
                    buffer[0][i].node,buffer[0][i].vnum,buffer[0][i].field);
            success = 0;
          }
      }
#else  /* VECTOR */
      if (_cread(fd,(char *)buffer,len*sizeof(struct DATA))
          != (len*sizeof(struct DATA)))
        pfslib_perror ("_cread()");
      if (mode == M_LOG)
      {
        ic = buffer[0].iter;
        ncn = ncx = buffer[0].node;
      }
      for (i=0; i<len;i++)
        if ((buffer[i].mode  != mc) ||
            (buffer[i].node < ncn) ||
            (buffer[i].node > ncx) ||
            (buffer[i].iter != ic) ||
            (buffer[i].field != ((char)i+'0')))
        {
          fprintf(stderr,
                  "%s %s: In Iter %d Nd %d Elt %d Expected '%c%c[%c,%c]%c' Got '%c%c%c%c'\n",
                  opstr(op),modestr(mode),it,n,i,
                  mc,ic,ncn,ncx,(char)i+'0',
                  buffer[i].mode,buffer[i].iter,
                  buffer[i].node,buffer[i].field);
          success = 0;
        }
#endif /* VECTOR */
    }
  }
  return;
}

void n_op
#ifdef ANSI_C
(int fd, int mode, optype op)
#else
(fd, mode, op)
int fd;
int mode;
optype op;
#endif
{
#ifdef VECTOR
  int v;
#endif /* VECTOR */
  int it;
  int iter;
  int len;
  int err = 0;
  long id[20];
  char errs[1000];
  
  setiomode(fd,mode);

  switch (mode)
  {
  case M_UNIX:
  case M_GLOBAL:
  case M_RECORD:
    iter = iterations;
    len  = length;
    break;
  case M_LOG:
    iter = iterations+mynum;
    len  = length;
    break;
  case M_SYNC:
    iter = iterations;
    len = length+mynum;
    break;    
  }
  
  if ((mynum == 0) && (!quiet))
    printf("Doing %s %s\n",opstr(op),modestr(mode));

#ifdef VECTOR
  for (v=0;v<vectorcnt;v++)
  {
    iov[v].iov_base = (caddr_t)&buffer[v][0];
    iov[v].iov_len  = (len+v)*sizeof(struct DATA);
  }
#endif
    
  for (it = 0; it < iter; it ++)
  {
    switch (op)
    {
    case N_CWRITE:
      set_wr_data(mode,len,it);
      if (IOOP(_cwrite) != IOOPLEN)
        err = 1;
      break;
    case N_CREAD:
      if (IOOP(_cread) != IOOPLEN)
        err = 1;
      else test_rd_data(N_CREAD,mode,len,it);
      break;
    case N_IWRITE_IOWAIT:
      set_wr_data(mode,len,it);
      if ((id[0] = IOOP(_iwrite)) < 0)
        err = 1;
      else if (_iowait(id[0]) < 0)
        err = 1;
      break;
    case N_IREAD_IOWAIT:
      if ((id[0] = IOOP(_iread)) < 0)
        err = 1;
      else if (_iowait(id[0]) < 0)
        err = 1;
      else test_rd_data(N_CREAD,mode,len,it);
      break;
    case N_IWRITE_N_IOWAIT:
      set_wr_data(mode,len,it);
      if ((id[it] = IOOP(_iwrite)) < 0)
        err = 1;
      break;
    case N_IREAD_N_IOWAIT:
      if ((id[it] = IOOP(_iread)) < 0)
        err = 1;
      break;
    default:
      break;
    }
    if (err)
    {
      sprintf(errs,"%d %s %s",mynum,opstr(op),modestr(mode));
      pfslib_perror(errs);
      exit (1);
    }
  }

  switch (op)
  {
  case N_IWRITE_N_IOWAIT:
  case N_IREAD_N_IOWAIT:
    for (it = 0; it < iter; it ++)
    {
      if (_iowait(id[it]) < 0)
      {
        sprintf(errs,"%d %s %s _iowait()",mynum,opstr(op),modestr(mode));
        pfslib_perror(errs);
        exit (1);
      }
    }
  default:
    break;
  }
  
  return;
}


void n_ops
#ifdef ANSI_C
(char *modes,char *ops)
#else
(modes, ops)
char *modes;
char *ops;
#endif
{
  char *mp;
  char *op;
  int mode;
  int ifd;
  int ofd;
  optype optr,optw;
  off_t ofdposC,ofdposO;

  if (append)
    ofd  = gopen(OUTPUTFILE,O_CREAT|O_TRUNC|O_RDWR|O_APPEND,M_UNIX,0600);
  else
    ofd  = gopen(OUTPUTFILE,O_CREAT|O_TRUNC|O_RDWR,M_UNIX,0600);
    
  ifd  = gopen(INPUTFILE,O_CREAT|O_TRUNC|O_RDWR,M_UNIX,0600);

  if (mynum == 0)
  {
    if (!quiet) printf("Writing input data\n");
    for (mp = modes; *mp != '\0'; mp++)
    {
      switch (*mp)
      {
      case 'u':
        mode = M_UNIX;
        break;
      case 'g':
        mode = M_GLOBAL;
        break;
      case 'l':
        mode = M_LOG;
        break;
      case 's':
        mode = M_SYNC;
        break;
      case 'r':
        mode = M_RECORD;
        break;
      default:
        fprintf(stderr,"UNKNOWN MODE\n");
        exit(1);
      }
      wr_input(ifd,mode);
    }
  }

  for (op = ops; *op != '\0'; op++)
  {
    ofdposC = lseek(ofd,0,SEEK_SET);
    lseek(ifd,0,SEEK_SET);
    
    for (mp = modes; *mp != '\0'; mp++)
    {
      switch (*mp)
      {
      case 'u':
        mode = M_UNIX;
        break;
      case 'g':
        mode = M_GLOBAL;
        break;
      case 'l':
        mode = M_LOG;
        break;
      case 's':
        mode = M_SYNC;
        break;
      case 'r':
        mode = M_RECORD;
        break;
      default:
        fprintf(stderr,"UNKNOWN MODE\n");
        break;
      }

      switch (*op)
      {
      case 'c':
        optr  = N_CREAD;
        optw  = N_CWRITE;
        break;
      case 'w':
        optr  = N_IREAD_IOWAIT;
        optw  = N_IWRITE_IOWAIT;
        break;
      case 'i':
        optr  = N_IREAD_N_IOWAIT;
        optw  = N_IWRITE_N_IOWAIT;
        break;
      default:
        fprintf(stderr,"UNKNOWN OPERATION\n");
        break;
      }
      n_op(ifd,mode,optr);      /* Read */

      n_op(ofd,mode,optw);      /* Write */
      setiomode(ofd,M_UNIX);    /* Synchronize before check */
      if (mynum == 0)
      {
        ofdposO = lseek(ofd,0,SEEK_CUR);
        lseek(ofd,ofdposC,SEEK_SET);
        chk_output(optw,ofd,mode);
        ofdposC = lseek(ofd,0,SEEK_CUR);
        lseek(ofd,ofdposO,SEEK_SET);
      }
    }
  }
  
  
  close (ifd);
  close (ofd);
  
  return;
}    
  
int main
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int argc;
char **argv;
#endif
{
  int c;
  int i;
  int chpid;
  char *ops = PERMOP; 
  char *modes = PERMMODES;

  int dbg = 1;

  while ((c = getopt(argc,argv,OPTIONSTRING)) != -1)
  {
    switch (c)
    {
    case 'a':
      append = 1;
      break;
    case 'k':
      nocheck = 1;
      break;
    case 'h':                   /* Hostname */
      pfsdhost = optarg;
      break;
    case 'n':                   /* Number of clients */
#ifdef NXLIB
      fprintf(stderr,"%s: warning -n flag will be ignored. Use -sz NXLib flag\n",argv[0]);
#else  /* NXLIB */
      numclnts = atoi(optarg);
#endif
      break;
    case 's':                   /* server threshold */
      svc_thr = atoi(optarg);
      break;
    case 'c':                   /* client threshold */
      clt_thr = atoi(optarg);
      break;
    case 'i':                   /* iterations */
      iterations = atoi(optarg);
      break;
    case 'l':                   /* length of data to write */
      length = atoi(optarg);
      break;
    case 'm':
      modes = optarg;
      break;
    case 'o':
      ops = optarg;
      break;
    case 'q':
      quiet = 1;
      break;
#ifdef VECTOR
    case 'v':
      vectorcnt = atoi(optarg);
      break;
#endif /* VECTOR */
    case '?':
      USAGE;
      exit (1);
    }
  }
  
  if ((length+numclnts-1) > BUFFSIZE)
  {
    fprintf(stderr,"%s: Buffer to small for -l parameter\n", argv[0]);
    USAGE;
    exit (1);
  }
  
#ifdef VECTOR
  if (vectorcnt > VECTORCNT)
  {
    fprintf(stderr,"%s: -v option to large\n",argv[0]);
    USAGE;
    exit(1);
  }
#endif /* VECTOR */

#ifdef NXLIB
  mynum = mynode();
  numclnts = numnodes();
#else  /* NXLIB */
  mynum = 0;

  for (i=1; i<numclnts; i++)
  {
    if ((chpid = fork()) == -1)
    {
      perror("fork()");
      exit(1);
    }
    if (chpid == 0)
    {
      mynum = i;
      break;
    }
    
  }
#endif /* NXLIB */

/*  while (dbg); */

  if (_pfslib_init(pfsdhost,numclnts,mynum,svc_thr,clt_thr) < 0)
  {
    pfslib_perror("_pfslib_init()");
    exit(1);
  }
  

  n_ops(modes,ops);
  
  if (!success)
  {
    if (mynum == 0) fprintf(stderr,"%s: Error(s) occured\n", argv[0]);
    exit(1);
  }

  if (mynum == 0) printf("%s: All tests done successfuly\n",argv[0]);
  exit (0);
}

