/* ************************************************************************* *
 *                                                                           *
 *    pfsrm.c,v
 *    Command to remove a PFSLib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfsrm.c,v
 *  RCS Date     : 1996/10/18 14:41:08
 *  RCS Revision : 1.4
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfsrm.c,v 1.4 1996/10/18 14:41:08 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/tcp.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef SUN4
#include <memory.h>
#else
#include <string.h>
#endif /* SUN4 */
#include <unistd.h>

#include "global.h"
#include "pfsd.h"
#include "rpc_defaults.h"

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Remove a PFSLib file and the asociated distributed files.                 *
 * ************************************************************************* */
int main
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  CLIENT *clnt;

  struct hostent *hp;
  struct sockaddr_in addr;
  struct timeval ti;
  int sockp = RPC_ANYSOCK;

  char fname[MAXNLEN];
  
  errorres    *result;
  resetargs   args;

  int ac;

  if ( argc < 3)
  {
    fprintf(stdout,"usage: %s <pfsd_host> <fname(1)> <fname(2)> ... <fname(n)>\n", argv[0]);
    exit(1);
  }

  if ((hp = gethostbyname(argv[1])) == (struct hostent *)0)
  {
    perror("gethostbyname()");
    exit (1);
  }

  memset(&addr, 0, sizeof(struct sockaddr_in));
  addr.sin_family = AF_INET;
  memcpy(&addr.sin_addr, hp->h_addr, (size_t)hp->h_length);
  addr.sin_port = htons(0);
  ti.tv_sec  = RPC_UDP_TIMEOUT;
  ti.tv_usec = 0;
  
  if ((clnt = clntudp_create(&addr, PFSD, PFSD_VERS, ti, &sockp)) == NULL)
  {
    clnt_pcreateerror("clntudp_create()");
    exit(1);
  }

  auth_destroy(clnt->cl_auth);
  clnt->cl_auth = authunix_create_default();

  /* Reset file(s) */
  for (ac=2; ac<argc; ac++ )
  {
    if (argv[ac][0] == '/')
    {
      args.fname = argv[ac];
    }
    else
    {
      getcwd(fname,MAXNLEN - strlen(argv[2]));
      strcat(fname,argv[2]);
      args.fname = fname;
    }

    if ((result = pfsd_unlink_1(&args, clnt)) == NULL)
    {
      clnt_perror(clnt,"pfsd_unlink_1() call failed");
      auth_destroy(clnt->cl_auth);
      clnt_destroy(clnt);
      close(sockp);
      exit(1);
    }
    
    if (result->stat == RPC_ERR)
    {
      fprintf(stderr,"Removing of file %s failed: %s\n",
              args.fname,
              result->errorres_u.err.errstr);
    }
    else
    {
      fprintf(stdout,"Removed %s\n",argv[ac]);
    }
    
    xdr_free(xdr_errorres, (char *)result);
  }

  auth_destroy(clnt->cl_auth);
  clnt_destroy(clnt);
  close(sockp);

  exit(0);
}
