/* ************************************************************************* *
 *                                                                           *
 *    pfscat.c,v
 *    Command to print a PFSLib file to stdout
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : pfscat.c,v
 *  RCS Date     : 1996/04/24 14:26:13
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "pfscat.c,v 1.1 1996/04/24 14:26:13 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "pfslib.h"

/* ************************************************************************* *
 * Defintions
 * ************************************************************************* */
#define MAXBUFSZ 1048576

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Copy a PFSlib file to a regular file                                      *
 * ************************************************************************* */
int main
#ifdef ANSI_C
(int argc, char **argv)
#else  /* ANSI_C */
(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  char *pfsdhost;
  char infile[MAXNLEN];
  mode_t mode;
  int ifd;
  char *buffer;
  off_t end;
  long tr;
  long rd;

  if (argc != 3)
  {
    fprintf(stderr,"Usage: %s pfsdhost infile\n",argv[0]);
    exit(1);
  }

  pfsdhost = argv[1];

  if (argv[2][0] == '/')
  {
    strcpy(infile,argv[2]);
  }
  else
  {
    getcwd(infile,MAXNLEN - strlen(argv[2]));
    strcat(infile,argv[2]);
  }

  _pfslib_init(pfsdhost,1,0,-1,-1);
  
  ifd = gopen(infile,O_RDONLY,M_UNIX,mode);
  
  end = lseek(ifd,0,SEEK_END);
  lseek(ifd,0,SEEK_SET);

  if ((buffer = (char *)malloc((size_t)(end > MAXBUFSZ ? MAXBUFSZ : end)))
      == NULL)
  {
    perror("malloc()");
    exit(1);
  }
  
  for (tr=end;tr > 0; tr -= rd)
  {
    if ((rd = _cread(ifd,buffer,(size_t)(tr > MAXBUFSZ ? MAXBUFSZ : tr))) < 0)
    {
      pfslib_perror("_cread()");
      exit(1);
    }
    
    if (write(fileno(stdout),buffer,(size_t)rd) != rd)
    {
      perror("write()");
      exit(1);
    }
  }
  
  close(ifd);
  exit(0);
}




  
