/* ************************************************************************* *
 *                                                                           *
 *    clnt_timing.c,v
 *    Client procedures to time internal PFSLib functions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_timing.c,v
 *  RCS Date     : 1996/10/18 14:40:03
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts,                                                *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_timing.c,v 1.2 1996/10/18 14:40:03 lamberts V2_0_B";
#endif

#ifdef TIMING

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <stdio.h>
#include <sys/time.h>
#include <stdlib.h>
#include <math.h>

/* ************************************************************************* *
 * Global variables                                                          *
 * ************************************************************************* */


#define DFN_TIMER(a) \
double _tm_sum_ ## a   = 0.0;\
double _tm_sqsum_ ## a = 0.0;\
double _tm_max_ ## a   = 0.0;\
double _tm_min_ ## a   = 0.0;\
int    _tm_cnt_ ## a   = 0;\
double _tm_start_ ## a = 0.0;\
double _tm_time_ ## a  = 0.0;

DFN_TIMER(_ioop)
DFN_TIMER(pfslib_ioop)
DFN_TIMER(basic_ioop)
DFN_TIMER(pfsd_getlist)
DFN_TIMER(open)
DFN_TIMER(lseek)
DFN_TIMER(write)
DFN_TIMER(read)
DFN_TIMER(close)
DFN_TIMER(xdr_free)
DFN_TIMER(pfsd_ioopdone)
DFN_TIMER(_getioID)
DFN_TIMER(pfsd_getioid)
DFN_TIMER(_iod_clnt_create)
DFN_TIMER(_iod_ioop)
DFN_TIMER(clnt_destroy)
DFN_TIMER(fork)
DFN_TIMER(_iowait)
DFN_TIMER(waitpid)
DFN_TIMER(_copy_child_shm)
DFN_TIMER(pfsd_iowait)


/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Get time of day in double format                                          *
 * ************************************************************************* */
double dclock
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  struct timeval t;
  struct timezone tz;
  
  if (gettimeofday(&t,&tz) < 0)
    return(-1.0);
  
  return ((double)((double)t.tv_sec + ((double)t.tv_usec*(double)0.000001)));

}

#define RST_TIMER(a) \
_tm_sum_ ## a   = 0.0;\
_tm_sqsum_ ## a = 0.0;\
_tm_max_ ## a   = 0.0;\
_tm_min_ ## a   = 0.0;\
_tm_cnt_ ## a   = 0;\
_tm_start_ ## a = 0.0;\
_tm_time_ ## a  = 0.0


/* ************************************************************************* *
 * Reset timers                                                              *
 * ************************************************************************* */
void reset_timing
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  
  RST_TIMER(_ioop);
  RST_TIMER(pfslib_ioop);
  RST_TIMER(basic_ioop);
  RST_TIMER(pfsd_getlist);
  RST_TIMER(open);
  RST_TIMER(lseek);
  RST_TIMER(write);
  RST_TIMER(read);
  RST_TIMER(close);
  RST_TIMER(xdr_free);
  RST_TIMER(pfsd_ioopdone);
  RST_TIMER(_getioID);
  RST_TIMER(pfsd_getioid);
  RST_TIMER(_iod_clnt_create);
  RST_TIMER(_iod_ioop);
  RST_TIMER(clnt_destroy);
  RST_TIMER(_iowait);
  RST_TIMER(waitpid);
  RST_TIMER(_copy_child_shm);
  RST_TIMER(pfsd_iowait);

  return;
}



/* ************************************************************************* *
 * Print timing values and reset timers                                      *
 * ************************************************************************* */
void print_timing
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  if (_tm_sum_pfsd_getioid != 0.0)
    printf("%7s %7.4f %15s %s\n",
           "",
           _tm_sum_pfsd_getioid,
           "",
           "pfsd_getioid");
  if (_tm_sum__getioID != 0.0)
    printf("%7s %7.4f %7.4f %7s %s\n\n",
           "",
           _tm_sum_pfsd_getioid,
           _tm_sum__getioID,
           "",
           "_getioID");
  if (_tm_sum_pfsd_getlist != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_pfsd_getlist,
           "",
           "pfsd_getlist");
  if (_tm_sum_open != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_open,
           "",
           "open");
  if (_tm_sum_lseek != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_lseek,
           "",
           "lseek");
  if (_tm_sum_write != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_write,
           "",
           "write");
  if (_tm_sum_read != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_read,
           "",
           "read");
  if (_tm_sum_close != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_close,
           "",
           "close");
  if (_tm_sum__iod_clnt_create != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum__iod_clnt_create,
           "",
           "_iod_clnt_create");
  if (_tm_sum__iod_ioop != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum__iod_ioop,
           "",
           "_iod_ioop");
  if (_tm_sum_clnt_destroy != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_clnt_destroy,
           "",
           "clnt_destroy");
  if (_tm_sum_xdr_free != 0.0)
    printf("%7.4f %23s %s\n",
           _tm_sum_xdr_free,
           "",
           "xdr_free");
  if (_tm_sum_basic_ioop != 0.0)
    printf("%7.4f %7.4f %15s %s\n",
           _tm_sum_pfsd_getlist
           +_tm_sum_open
           +_tm_sum_lseek
           +_tm_sum_write
           +_tm_sum_close
           +_tm_sum__iod_clnt_create
           +_tm_sum__iod_ioop
           +_tm_sum_clnt_destroy
           +_tm_sum_xdr_free,
           _tm_sum_basic_ioop,
           "",
           "basic_ioop");
  if (_tm_sum_fork != 0.0)
    printf("%7s %7.4f %15s %s\n",
           "",
           _tm_sum_fork,
           "",
           "fork");
  if (_tm_sum_pfsd_ioopdone != 0.0)
    printf("%7s %7.4f %15s %s\n",
           "",
           _tm_sum_pfsd_ioopdone,
           "",
           "pfsd_ioopdone");
  if (_tm_sum_pfslib_ioop != 0.0)
    printf("%7s %7.4f %7.4f %7s %s\n",
           "",
           _tm_sum_basic_ioop
           +_tm_sum_pfsd_ioopdone
           +_tm_sum_fork,
           _tm_sum_pfslib_ioop,
           "",
           "pfslib_ioop");
  if (_tm_sum__ioop != 0.0)
    printf("%7s %7s %7.4f %7.4f %s\n",
           "","",
           _tm_sum__getioID
           +_tm_sum_pfslib_ioop,
           _tm_sum__ioop,
           "_ioop");
  if (_tm_sum_waitpid != 0.0)
    printf("%7s %7.4s %7.4f %7s %s\n",
           "","",
           _tm_sum_waitpid,
           "",
           "waitpid");
  if (_tm_sum__copy_child_shm != 0.0)
    printf("%7s %7.4s %7.4f %7s %s\n",
           "","",
           _tm_sum__copy_child_shm,
           "",
           "_copy_child_shm");
  if (_tm_sum_pfsd_iowait != 0.0)
    printf("%7s %7.4s %7.4f %7s %s\n",
           "","",
           _tm_sum_pfsd_iowait,
           "",
           "pfsd_iowait");
  if (_tm_sum__iowait != 0.0)
    printf("%7s %7s %7.4f %7.4f %s\n",
           "","",
           _tm_sum_waitpid
           +_tm_sum__copy_child_shm
           +_tm_sum_pfsd_iowait,
           _tm_sum__iowait,
           "_iowait");

  return;
}

#define LATEX_BEGIN_A "\
\n\\begin{tabular*}{\\textwidth}{l@{\\extracolsep{\\fill}}rrrrrc|rr}\n"
#define LATEX_BEGIN_B "\
                          &      & \\multicolumn{4}{c}{Prozeduraufrufebene}\n\
                                                                && \\multicolumn{1}{c}{RPC}\n\
                                                                         & \\multicolumn{1}{c}{ohne}\\\\\n\
Prozedur                  & \\multicolumn{1}{c}{N}\n\
                                 & \\multicolumn{1}{c}{1}\n\
                                          & \\multicolumn{1}{c}{2}\n\
                                                   & \\multicolumn{1}{c}{3}\n\
                                                            & \\multicolumn{1}{c}{4}\n\
                                                                     && \\multicolumn{1}{c}{Aufrufe}\n\
                                                                               & \\multicolumn{1}{c}{RPC}\\\\\n\
\\hline\n"


void print_latex_timing_sum
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  printf(LATEX_BEGIN_A);

  printf("\\multicolumn{9}{c}{Gesamtzeiten in ms}\\\\\n");
         
  printf(LATEX_BEGIN_B);

  if (_tm_cnt_pfsd_getioid > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_getioid",
           _tm_cnt_pfsd_getioid,
           "","",
           _tm_sum_pfsd_getioid,
           "",
           _tm_sum_pfsd_getioid,
           "");
  if (_tm_cnt__getioID > 0)
  {
    printf("\\cline{5-5}\n");
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~\\_getioID",
           _tm_cnt__getioID,
           "",
           _tm_sum__getioID,
           _tm_sum_pfsd_getioid,
           "","","");
    printf("\\cline{5-5}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{5-5}\n");
  }
  if (_tm_cnt_pfsd_getlist > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~pfsd\\_getlist",
           _tm_cnt_pfsd_getlist,
           "","","",
           _tm_sum_pfsd_getlist,
           _tm_sum_pfsd_getlist,
           "");
  if (_tm_cnt_open > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~open",
           _tm_cnt_open,
           "","","",
           _tm_sum_open,
           "","");
  if (_tm_cnt_lseek > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~lseek",
           _tm_cnt_lseek,
           "","","",
           _tm_sum_lseek,
           "","");
  if (_tm_cnt_write > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~write",
           _tm_cnt_write,
           "","","",
           _tm_sum_write,
           "","");
  if (_tm_cnt_read > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~read",
           _tm_cnt_read,
           "","","",
           _tm_sum_read,
           "","");
  if (_tm_cnt_close > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~close",
           _tm_cnt_close,
           "","","",
           _tm_sum_close,
           "","");
  if (_tm_cnt__iod_clnt_create > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_clnt\\_create",
           _tm_cnt__iod_clnt_create,
           "","","",
           _tm_sum__iod_clnt_create,
           _tm_sum__iod_clnt_create,
           "");
  if (_tm_cnt__iod_ioop > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_ioop",
           _tm_cnt__iod_ioop,
           "","","",
           _tm_sum__iod_ioop,
           _tm_sum__iod_ioop,
           "");
  if (_tm_cnt_clnt_destroy > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~clnt\\_destroy",
           _tm_cnt_clnt_destroy,
           "","","",
           _tm_sum_clnt_destroy,
           _tm_sum_clnt_destroy,
           "");
  if (_tm_cnt_xdr_free > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~xdr\\_free",
           _tm_cnt_xdr_free,
           "","","",
           _tm_sum_xdr_free,
           _tm_sum_xdr_free,
           "");
  if (_tm_cnt_basic_ioop > 0)
  {
    printf("\\cline{6-6}\n");
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~basic\\_ioop",
           _tm_cnt_basic_ioop,
           "","",
           _tm_sum_basic_ioop,
           _tm_sum_pfsd_getlist
           +_tm_sum_open
           +_tm_sum_lseek
           +_tm_sum_write
           +_tm_sum_close
           +_tm_sum__iod_clnt_create
           +_tm_sum__iod_ioop
           +_tm_sum_clnt_destroy
           +_tm_sum_xdr_free,
           "","");
    printf("\\cline{6-6}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{6-6}\n");
  }
  if (_tm_cnt_fork > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~fork",
           _tm_cnt_fork,
           "","",
           _tm_sum_fork,
           "","","");
  if (_tm_cnt_pfsd_ioopdone > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_ioopdone",
           _tm_cnt_pfsd_ioopdone,
           "","",
           _tm_sum_pfsd_ioopdone,
           "",
           _tm_sum_pfsd_ioopdone,
           "");
  if (_tm_cnt_pfslib_ioop > 0)
  {
    printf("\\cline{5-5}\n");
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~pfslib\\_ioop",
           _tm_cnt_pfslib_ioop,
           "",
           _tm_sum_pfslib_ioop,
           _tm_sum_basic_ioop
           +_tm_sum_pfsd_ioopdone
           +_tm_sum_fork,
           "","","");
    printf("\\cline{5-5}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{5-5}\n");
  }
  if (_tm_cnt__ioop > 0)
  {
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("%-25s &%5d &%7.4f &%7.4f &%7.4s &%7.4s && %7.4f &%7.4f\\\\\n",
           "\\_ioop",
           _tm_cnt__ioop,
           _tm_sum__ioop,
           _tm_sum__getioID
           +_tm_sum_pfslib_ioop,
           "","",
           _tm_sum_pfsd_getioid
           +_tm_sum_pfsd_getlist
           +_tm_sum__iod_clnt_create
           +_tm_sum__iod_ioop
           +_tm_sum_clnt_destroy
           +_tm_sum_xdr_free
           +_tm_sum_pfsd_ioopdone,
           _tm_sum__ioop
           -_tm_sum_pfsd_getioid
           -_tm_sum_pfsd_getlist
           -_tm_sum__iod_clnt_create
           -_tm_sum__iod_ioop
           -_tm_sum_clnt_destroy
           -_tm_sum_xdr_free
           -_tm_sum_pfsd_ioopdone);
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("\\\\[\\doubleclinesep]\n");
    printf("\\cline{4-4}\\cline{8-8}\n");
  }
  if (_tm_cnt__iowait > 0)
    printf("\\\\[.5\\doubleclinesep]\n\\hline\n");
  if (_tm_cnt_waitpid > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~waitpid",
           _tm_cnt_waitpid,
           "",
           _tm_sum_waitpid,
           "","","","");
  if (_tm_cnt__copy_child_shm > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~_copy_child_shm",
           _tm_cnt__copy_child_shm,
           "",
           _tm_sum__copy_child_shm,
           "","","","");
  if (_tm_cnt_pfsd_iowait > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~pfsd\\_iowait",
           _tm_cnt_pfsd_iowait,
           "",
           _tm_sum_pfsd_iowait,
           "","",
           _tm_sum_pfsd_iowait,
           "");
  if (_tm_cnt__iowait > 0)
  {
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("%-25s &%5d &%7.4f &%7.4f &%7.4s &%7.4s && %7.4f &%7.4f\\\\\n",
           "\\_iowait",
           _tm_cnt__iowait,
           _tm_sum__iowait,
           _tm_sum_waitpid
           +_tm_sum__copy_child_shm
           +_tm_sum_pfsd_iowait,
           "","",
           _tm_sum_pfsd_iowait,
           _tm_sum__iowait
           -_tm_sum_pfsd_iowait);
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("\\\\[\\doubleclinesep]\n");
    printf("\\cline{4-4}\\cline{8-8}\n");
  }
  
  printf("\\end{tabular*}\n\n");

  return;
}

void print_latex_timing_avg
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  printf(LATEX_BEGIN_A);

  printf("\\multicolumn{9}{c}{durchschnittliche Zeiten in ms}\\\\\n");

  printf(LATEX_BEGIN_B);

  if (_tm_cnt_pfsd_getioid > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_getioid",
           _tm_cnt_pfsd_getioid,
           "","",
           _tm_sum_pfsd_getioid/(double)_tm_cnt_pfsd_getioid,
           "",
           _tm_sum_pfsd_getioid/(double)_tm_cnt_pfsd_getioid,
           "");
  if (_tm_cnt__getioID > 0)
  {
    printf("\\cline{5-5}\n");
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~\\_getioID",
           _tm_cnt__getioID,
           "",
           _tm_sum__getioID/(double)_tm_cnt__getioID,
           _tm_sum_pfsd_getioid/(double)_tm_cnt_pfsd_getioid,
           "","","");
    printf("\\cline{5-5}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{5-5}\n");
  }
  if (_tm_cnt_pfsd_getlist > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~pfsd\\_getlist",
           _tm_cnt_pfsd_getlist,
           "","","",
           _tm_sum_pfsd_getlist/(double)_tm_cnt_pfsd_getlist,
           _tm_sum_pfsd_getlist/(double)_tm_cnt_pfsd_getlist,
           "");
  if (_tm_cnt_open > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~open",
           _tm_cnt_open,
           "","","",
           _tm_sum_open/(double)_tm_cnt_open,
           "","");
  if (_tm_cnt_lseek > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~lseek",
           _tm_cnt_lseek,
           "","","",
           _tm_sum_lseek/(double)_tm_cnt_lseek,
           "","");
  if (_tm_cnt_write > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~write",
           _tm_cnt_write,
           "","","",
           _tm_sum_write/(double)_tm_cnt_write,
           "","");
  if (_tm_cnt_read > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~read",
           _tm_cnt_read,
           "","","",
           _tm_sum_read/(double)_tm_cnt_read,
           "","");
  if (_tm_cnt_close > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~close",
           _tm_cnt_close,
           "","","",
           _tm_sum_close/(double)_tm_cnt_close,
           "","");
  if (_tm_cnt__iod_clnt_create > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_clnt\\_create",
           _tm_cnt__iod_clnt_create,
           "","","",
           _tm_sum__iod_clnt_create/(double)_tm_cnt__iod_clnt_create,
           _tm_sum__iod_clnt_create/(double)_tm_cnt__iod_clnt_create,
           "");
  if (_tm_cnt__iod_ioop > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_ioop",
           _tm_cnt__iod_ioop,
           "","","",
           _tm_sum__iod_ioop/(double)_tm_cnt__iod_ioop,
           _tm_sum__iod_ioop/(double)_tm_cnt__iod_ioop,
           "");
  if (_tm_cnt_clnt_destroy > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~clnt\\_destroy",
           _tm_cnt_clnt_destroy,
           "","","",
           _tm_sum_clnt_destroy/(double)_tm_cnt_clnt_destroy,
           _tm_sum_clnt_destroy/(double)_tm_cnt_clnt_destroy,
           "");
  if (_tm_cnt_xdr_free > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~xdr\\_free",
           _tm_cnt_xdr_free,
           "","","",
           _tm_sum_xdr_free/(double)_tm_cnt_xdr_free,
           _tm_sum_xdr_free/(double)_tm_cnt_xdr_free,
           "");
  if (_tm_cnt_basic_ioop > 0)
  {
    printf("\\cline{6-6}\n");
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~basic\\_ioop",
           _tm_cnt_basic_ioop,
           "","",
           _tm_sum_basic_ioop/(double)_tm_cnt_basic_ioop,
           (_tm_cnt_pfsd_getlist ?
            _tm_sum_pfsd_getlist/(double)_tm_cnt_pfsd_getlist :
            0.0)
           +(_tm_cnt_open ?
             _tm_sum_open/(double)_tm_cnt_open :
             0.0)
           +(_tm_cnt_lseek ?
             _tm_sum_lseek/(double)_tm_cnt_lseek :
             0.0)
           +(_tm_cnt_write ?
             _tm_sum_write/(double)_tm_cnt_write :
             0.0)
           +(_tm_cnt_close ?
             _tm_sum_close/(double)_tm_cnt_close :
             0.0)
           +(_tm_cnt__iod_clnt_create ?
             _tm_sum__iod_clnt_create/(double)_tm_cnt__iod_clnt_create :
             0.0)
           +(_tm_cnt__iod_ioop ?
             _tm_sum__iod_ioop/(double)_tm_cnt__iod_ioop :
             0.0)
           +(_tm_cnt_clnt_destroy ?
             _tm_sum_clnt_destroy/(double)_tm_cnt_clnt_destroy :
             0.0)
           +(_tm_cnt_xdr_free ?
             _tm_sum_xdr_free/(double)_tm_cnt_xdr_free :
             0.0),
           "","");
    printf("\\cline{6-6}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{6-6}\n");
  }
  if (_tm_cnt_fork > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~fork",
           _tm_cnt_fork,
           "","",
           _tm_sum_fork/(double)_tm_cnt_fork,
           "","","");
  if (_tm_cnt_pfsd_ioopdone > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_ioopdone",
           _tm_cnt_pfsd_ioopdone,
           "","",
           _tm_sum_pfsd_ioopdone/(double)_tm_cnt_pfsd_ioopdone,
           "",
           _tm_sum_pfsd_ioopdone/(double)_tm_cnt_pfsd_ioopdone,
           "");
  if (_tm_cnt_pfslib_ioop > 0)
  {
    printf("\\cline{5-5}\n");
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~pfslib\\_ioop",
           _tm_cnt_pfslib_ioop,
           "",
           _tm_sum_pfslib_ioop/(double)_tm_cnt_pfslib_ioop,
           (_tm_cnt_basic_ioop ?
            _tm_sum_basic_ioop/(double)_tm_cnt_basic_ioop :
            0.0)
           +(_tm_cnt_pfsd_ioopdone ?
             _tm_sum_pfsd_ioopdone/(double)_tm_cnt_pfsd_ioopdone :
             0.0)
           +(_tm_cnt_fork ?
             _tm_sum_fork/(double)_tm_cnt_fork :
             0.0),
           "","","");
    printf("\\cline{5-5}\n&&&&&&&&\\\\[\\doubleclinesep]\n\\cline{5-5}\n");
  }
  if (_tm_cnt__ioop > 0)
  {
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("%-25s &%5d &%7.4f &%7.4f &%7.4s &%7.4s && %7.4f &%7.4f\\\\\n",
           "\\_ioop",
           _tm_cnt__ioop,
           _tm_sum__ioop/(double)_tm_cnt__ioop,
           (_tm_cnt__getioID ?
            _tm_sum__getioID/(double)_tm_cnt__getioID :
            0.0)
           +(_tm_cnt_pfslib_ioop ?
             _tm_sum_pfslib_ioop/(double)_tm_cnt_pfslib_ioop :
             0.0),
           "","",
           (_tm_cnt_pfsd_getioid ?
            _tm_sum_pfsd_getioid/(double)_tm_cnt_pfsd_getioid :
            0.0)
           +(_tm_cnt_pfsd_getlist ?
             _tm_sum_pfsd_getlist/(double)_tm_cnt_pfsd_getlist :
             0.0)
           +(_tm_cnt__iod_clnt_create ?
             _tm_sum__iod_clnt_create/(double)_tm_cnt__iod_clnt_create :
             0.0)
           +(_tm_cnt__iod_ioop ?
             _tm_sum__iod_ioop/(double)_tm_cnt__iod_ioop :
             0.0)
           +(_tm_cnt_clnt_destroy ?
             _tm_sum_clnt_destroy/(double)_tm_cnt_clnt_destroy :
             0.0)
           +(_tm_cnt_xdr_free ?
             _tm_sum_xdr_free/(double)_tm_cnt_xdr_free :
             0.0)
           +(_tm_cnt_pfsd_ioopdone ?
             _tm_sum_pfsd_ioopdone/(double)_tm_cnt_pfsd_ioopdone :
             0.0),
           (_tm_cnt__ioop ?
            _tm_sum__ioop/(double)_tm_cnt__ioop :
            0.0)
           -(_tm_cnt_pfsd_getioid ?
             _tm_sum_pfsd_getioid/(double)_tm_cnt_pfsd_getioid :
             0.0)
           -(_tm_cnt_pfsd_getlist ?
             _tm_sum_pfsd_getlist/(double)_tm_cnt_pfsd_getlist :
             0.0)
           -(_tm_cnt__iod_clnt_create ?
             _tm_sum__iod_clnt_create/(double)_tm_cnt__iod_clnt_create :
             0.0)
           -(_tm_cnt__iod_ioop ?
             _tm_sum__iod_ioop/(double)_tm_cnt__iod_ioop :
             0.0)
           -(_tm_cnt_clnt_destroy ?
             _tm_sum_clnt_destroy/(double)_tm_cnt_clnt_destroy :
             0.0)
           -(_tm_cnt_xdr_free ?
             _tm_sum_xdr_free/(double)_tm_cnt_xdr_free :
             0.0)
           -(_tm_cnt_pfsd_ioopdone ?
             _tm_sum_pfsd_ioopdone/(double)_tm_cnt_pfsd_ioopdone :
             0.0));
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("\\\\[\\doubleclinesep]\n");
    printf("\\cline{4-4}\\cline{8-8}\n");
  }
  if (_tm_cnt__iowait > 0)
    printf("\\\\[.5\\doubleclinesep]\n\\hline\n");
  if (_tm_cnt_waitpid > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~waitpid",
           _tm_cnt_waitpid,
           "",
           _tm_sum_waitpid/(double)_tm_cnt_waitpid,
           "","","","");
  if (_tm_cnt__copy_child_shm > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~_copy_child_shm",
           _tm_cnt__copy_child_shm,
           "",
           _tm_sum__copy_child_shm/(double)_tm_cnt__copy_child_shm,
           "","","","");
  if (_tm_cnt_pfsd_iowait > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~pfsd\\_iowait",
           _tm_cnt_pfsd_iowait,
           "",
           _tm_sum_pfsd_iowait/(double)_tm_cnt_pfsd_iowait,
           "","",
           _tm_sum_pfsd_iowait/(double)_tm_cnt_pfsd_iowait,
           "");
  if (_tm_cnt__iowait > 0)
  {
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("%-25s &%5d &%7.4f &%7.4f &%7.4s &%7.4s && %7.4f &%7.4f\\\\\n",
           "\\_iowait",
           _tm_cnt__iowait,
           _tm_sum__iowait/(double)_tm_cnt__iowait,
           (_tm_cnt_waitpid ?
            _tm_sum_waitpid/(double)_tm_cnt_waitpid :
            0.0)
           +(_tm_cnt__copy_child_shm ?
             _tm_sum__copy_child_shm/(double)_tm_cnt__copy_child_shm :
             0.0)
           +(_tm_cnt_pfsd_iowait ?
             _tm_sum_pfsd_iowait/(double)_tm_cnt_pfsd_iowait :
             0.0),
           "","",
           _tm_sum_pfsd_iowait/(double)_tm_cnt_pfsd_iowait,
           (_tm_cnt__ioop ?
            _tm_sum__iowait/(double)_tm_cnt__ioop :
            0.0)
           -(_tm_cnt_pfsd_iowait ?
             _tm_sum_pfsd_iowait/(double)_tm_cnt_pfsd_iowait :
             0.0));
    printf("\\cline{4-4}\\cline{8-8}\n");
    printf("\\\\[\\doubleclinesep]\n");
    printf("\\cline{4-4}\\cline{8-8}\n");
  }
  
  printf("\\end{tabular*}\n\n");

  return;
}


void print_latex_timing_max
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  printf(LATEX_BEGIN_A);

  printf("\\multicolumn{9}{c}{Maximalzeiten in ms}\\\\\n");
         
  printf(LATEX_BEGIN_B);

  if (_tm_cnt_pfsd_getioid > 0)
    printf("%-25s &%5d  &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_getioid",
           _tm_cnt_pfsd_getioid,
           "","",
           _tm_max_pfsd_getioid,
           "",
           _tm_max_pfsd_getioid,
           "");
  if (_tm_cnt__getioID > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~\\_getioID",
           _tm_cnt__getioID,
           "",
           _tm_max__getioID,
           "","","","");
  if (_tm_cnt_pfsd_getlist > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~pfsd\\_getlist",
           _tm_cnt_pfsd_getlist,
           "","","",
           _tm_max_pfsd_getlist,
           _tm_max_pfsd_getlist,
           "");
  if (_tm_cnt_open > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~open",
           _tm_cnt_open,
           "","","",
           _tm_max_open,
           "","");
  if (_tm_cnt_lseek > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~lseek",
           _tm_cnt_lseek,
           "","","",
           _tm_max_lseek,
           "","");
  if (_tm_cnt_write > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~write",
           _tm_cnt_write,
           "","","",
           _tm_max_write,
           "","");
  if (_tm_cnt_read > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~read",
           _tm_cnt_read,
           "","","",
           _tm_max_read,
           "","");
  if (_tm_cnt_close > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~close",
           _tm_cnt_close,
           "","","",
           _tm_max_close,
           "","");
  if (_tm_cnt__iod_clnt_create > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_clnt\\_create",
           _tm_cnt__iod_clnt_create,
           "","","",
           _tm_max__iod_clnt_create,
           _tm_max__iod_clnt_create,
           "");
  if (_tm_cnt__iod_ioop > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_ioop",
           _tm_cnt__iod_ioop,
           "","","",
           _tm_max__iod_ioop,
           _tm_max__iod_ioop,
           "");
  if (_tm_cnt_clnt_destroy > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~clnt\\_destroy",
           _tm_cnt_clnt_destroy,
           "","","",
           _tm_max_clnt_destroy,
           _tm_max_clnt_destroy,
           "");
  if (_tm_cnt_xdr_free > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~xdr\\_free",
           _tm_cnt_xdr_free,
           "","","",
           _tm_max_xdr_free,
           _tm_max_xdr_free,
           "");
  if (_tm_cnt_basic_ioop > 0)
  {
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~basic\\_ioop",
           _tm_cnt_basic_ioop,
           "","",
           _tm_max_basic_ioop,
           "","","");
  }
  if (_tm_cnt_fork > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~fork",
           _tm_cnt_fork,
           "","",
           _tm_max_fork,
           "","","");
  if (_tm_cnt_pfsd_ioopdone > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_ioopdone",
           _tm_cnt_pfsd_ioopdone,
           "","",
           _tm_max_pfsd_ioopdone,
           "",
           _tm_max_pfsd_ioopdone,
           "");
  if (_tm_cnt_pfslib_ioop > 0)
  {
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~pfslib\\_ioop",
           _tm_cnt_pfslib_ioop,
           "",
           _tm_max_pfslib_ioop,
           "","","","");
  }
  if (_tm_cnt__ioop > 0)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_ioop",
           _tm_cnt__ioop,
           _tm_max__ioop,
           "","","","","");
  }
  if (_tm_cnt__iowait > 0)
    printf("\\\\[.5\\doubleclinesep]\n\\hline\n");
  if (_tm_cnt_waitpid > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~waitpid",
           _tm_cnt_waitpid,
           "",
           _tm_max_waitpid,
           "","","","");
  if (_tm_cnt__copy_child_shm > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~_copy_child_shm",
           _tm_cnt__copy_child_shm,
           "",
           _tm_max__copy_child_shm,
           "","","","");
  if (_tm_cnt_pfsd_iowait > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~pfsd\\_iowait",
           _tm_cnt_pfsd_iowait,
           "",
           _tm_max_pfsd_iowait,
           "","",
           _tm_max_pfsd_iowait,
           "");
  if (_tm_cnt__iowait > 0)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_iowait",
           _tm_cnt__iowait,
           _tm_max__iowait,
           "","","","","");
  }
  
  printf("\\end{tabular*}\n\n");

  return;
}

void print_latex_timing_min
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  printf(LATEX_BEGIN_A);

  printf("\\multicolumn{9}{c}{Minimalzeiten in ms}\\\\\n");
         
  printf(LATEX_BEGIN_B);

  if (_tm_cnt_pfsd_getioid > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_getioid",
           _tm_cnt_pfsd_getioid,
           "","",
           _tm_min_pfsd_getioid,
           "",
           _tm_min_pfsd_getioid,
           "");
  if (_tm_cnt__getioID > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~\\_getioID",
           _tm_cnt__getioID,
           "",
           _tm_min__getioID,
           "","","","");
  if (_tm_cnt_pfsd_getlist > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~pfsd\\_getlist",
           _tm_cnt_pfsd_getlist,
           "","","",
           _tm_min_pfsd_getlist,
           _tm_min_pfsd_getlist,
           "");
  if (_tm_cnt_open > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~open",
           _tm_cnt_open,
           "","","",
           _tm_min_open,
           "","");
  if (_tm_cnt_lseek > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~lseek",
           _tm_cnt_lseek,
           "","","",
           _tm_min_lseek,
           "","");
  if (_tm_cnt_write > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~write",
           _tm_cnt_write,
           "","","",
           _tm_min_write,
           "","");
  if (_tm_cnt_read > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~read",
           _tm_cnt_read,
           "","","",
           _tm_min_read,
           "","");
  if (_tm_cnt_close > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~close",
           _tm_cnt_close,
           "","","",
           _tm_min_close,
           "","");
  if (_tm_cnt__iod_clnt_create > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_clnt\\_create",
           _tm_cnt__iod_clnt_create,
           "","","",
           _tm_min__iod_clnt_create,
           _tm_min__iod_clnt_create,
           "");
  if (_tm_cnt__iod_ioop > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_ioop",
           _tm_cnt__iod_ioop,
           "","","",
           _tm_min__iod_ioop,
           _tm_min__iod_ioop,
           "");
  if (_tm_cnt_clnt_destroy > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~clnt\\_destroy",
           _tm_cnt_clnt_destroy,
           "","","",
           _tm_min_clnt_destroy,
           _tm_min_clnt_destroy,
           "");
  if (_tm_cnt_xdr_free > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~xdr\\_free",
           _tm_cnt_xdr_free,
           "","","",
           _tm_min_xdr_free,
           _tm_min_xdr_free,
           "");
  if (_tm_cnt_basic_ioop > 0)
  {
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~basic\\_ioop",
           _tm_cnt_basic_ioop,
           "","",
           _tm_min_basic_ioop,
           "","","");
  }
  if (_tm_cnt_fork > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~fork",
           _tm_cnt_fork,
           "","",
           _tm_min_fork,
           "","","");
  if (_tm_cnt_pfsd_ioopdone > 0)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_ioopdone",
           _tm_cnt_pfsd_ioopdone,
           "","",
           _tm_min_pfsd_ioopdone,
           "",
           _tm_min_pfsd_ioopdone,
           "");
  if (_tm_cnt_pfslib_ioop > 0)
  {
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~pfslib\\_ioop",
           _tm_cnt_pfslib_ioop,
           "",
           _tm_min_pfslib_ioop,
           "","","","");
  }
  if (_tm_cnt__ioop > 0)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_ioop",
           _tm_cnt__ioop,
           _tm_min__ioop,
           "","","","","");
  }
  if (_tm_cnt__iowait > 0)
    printf("\\\\[.5\\doubleclinesep]\n\\hline\n");
  if (_tm_cnt_waitpid > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~waitpid",
           _tm_cnt_waitpid,
           "",
           _tm_min_waitpid,
           "","","","");
  if (_tm_cnt__copy_child_shm > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~_copy_child_shm",
           _tm_cnt__copy_child_shm,
           "",
           _tm_min__copy_child_shm,
           "","","","");
  if (_tm_cnt_pfsd_iowait > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~pfsd\\_iowait",
           _tm_cnt_pfsd_iowait,
           "",
           _tm_min_pfsd_iowait,
           "","",
           _tm_min_pfsd_iowait,
           "");
  if (_tm_cnt__iowait > 0)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_iowait",
           _tm_cnt__iowait,
           _tm_min__iowait,
           "","","","","");
  }
  
  printf("\\end{tabular*}\n\n");

  return;
}

void print_latex_timing_std
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  printf(LATEX_BEGIN_A);

  printf("\\multicolumn{9}{c}{Standardabweichung}\\\\\n");
         
  printf(LATEX_BEGIN_B);

  if (_tm_cnt_pfsd_getioid > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_getioid",
           _tm_cnt_pfsd_getioid,
           "","",
           sqrt((_tm_sqsum_pfsd_getioid
                 -((_tm_sum_pfsd_getioid*_tm_sum_pfsd_getioid)
                   /(double)_tm_cnt_pfsd_getioid))
                /(double)(_tm_cnt_pfsd_getioid-1)),
           "",
           sqrt((_tm_sqsum_pfsd_getioid
                 -((_tm_sum_pfsd_getioid*_tm_sum_pfsd_getioid)
                   /(double)_tm_cnt_pfsd_getioid))
                /(double)(_tm_cnt_pfsd_getioid-1)),
           "");
  if (_tm_cnt__getioID > 1)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~\\_getioID",
           _tm_cnt__getioID,
           "",
           sqrt((_tm_sqsum__getioID
                 -((_tm_sum__getioID*_tm_sum__getioID)
                   /(double)_tm_cnt__getioID))
                /(double)(_tm_cnt__getioID-1)),
           "","","","");
  if (_tm_cnt_pfsd_getlist > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~pfsd\\_getlist",
           _tm_cnt_pfsd_getlist,
           "","","",
           sqrt((_tm_sqsum_pfsd_getlist
                 -((_tm_sum_pfsd_getlist*_tm_sum_pfsd_getlist)
                   /(double)_tm_cnt_pfsd_getlist))
                /(double)(_tm_cnt_pfsd_getlist-1)),
           sqrt((_tm_sqsum_pfsd_getlist
                 -((_tm_sum_pfsd_getlist*_tm_sum_pfsd_getlist)
                   /(double)_tm_cnt_pfsd_getlist))
                /(double)(_tm_cnt_pfsd_getlist-1)),
           "");
  if (_tm_cnt_open > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~open",
           _tm_cnt_open,
           "","","",
           sqrt((_tm_sqsum_open
                 -((_tm_sum_open*_tm_sum_open)
                   /(double)_tm_cnt_open))
                /(double)(_tm_cnt_open-1)),
           "","");
  if (_tm_cnt_lseek > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~lseek",
           _tm_cnt_lseek,
           "","","",
           sqrt((_tm_sqsum_lseek
                 -((_tm_sum_lseek*_tm_sum_lseek)
                   /(double)_tm_cnt_lseek))
                /(double)(_tm_cnt_lseek-1)),
           "","");
  if (_tm_cnt_write > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~write",
           _tm_cnt_write,
           "","","",
           sqrt((_tm_sqsum_write
                 -((_tm_sum_write*_tm_sum_write)
                   /(double)_tm_cnt_write))
                /(double)(_tm_cnt_write-1)),
           "","");
  if (_tm_cnt_read > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~read",
           _tm_cnt_read,
           "","","",
           sqrt((_tm_sqsum_read
                 -((_tm_sum_read*_tm_sum_read)
                   /(double)_tm_cnt_read))
                /(double)(_tm_cnt_read-1)),
           "","");
  if (_tm_cnt_close > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4s &%7.4s\\\\\n",
           "~~~~~~close",
           _tm_cnt_close,
           "","","",
           sqrt((_tm_sqsum_close
                 -((_tm_sum_close*_tm_sum_close)
                   /(double)_tm_cnt_close))
                /(double)(_tm_cnt_close-1)),
           "","");
  if (_tm_cnt__iod_clnt_create > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_clnt\\_create",
           _tm_cnt__iod_clnt_create,
           "","","",
           sqrt((_tm_sqsum__iod_clnt_create
                 -((_tm_sum__iod_clnt_create*_tm_sum__iod_clnt_create)
                   /(double)_tm_cnt__iod_clnt_create))
                /(double)(_tm_cnt__iod_clnt_create-1)),
           sqrt((_tm_sqsum__iod_clnt_create
                 -((_tm_sum__iod_clnt_create*_tm_sum__iod_clnt_create)
                   /(double)_tm_cnt__iod_clnt_create))
                /(double)(_tm_cnt__iod_clnt_create-1)),
           "");
  if (_tm_cnt__iod_ioop > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~\\_iod\\_ioop",
           _tm_cnt__iod_ioop,
           "","","",
           sqrt((_tm_sqsum__iod_ioop
                 -((_tm_sum__iod_ioop*_tm_sum__iod_ioop)
                   /(double)_tm_cnt__iod_ioop))
                /(double)(_tm_cnt__iod_ioop-1)),
           sqrt((_tm_sqsum__iod_ioop
                 -((_tm_sum__iod_ioop*_tm_sum__iod_ioop)
                   /(double)_tm_cnt__iod_ioop))
                /(double)(_tm_cnt__iod_ioop-1)),
           "");
  if (_tm_cnt_clnt_destroy > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~clnt\\_destroy",
           _tm_cnt_clnt_destroy,
           "","","",
           sqrt((_tm_sqsum_clnt_destroy
                 -((_tm_sum_clnt_destroy*_tm_sum_clnt_destroy)
                   /(double)_tm_cnt_clnt_destroy))
                /(double)(_tm_cnt_clnt_destroy-1)),
           sqrt((_tm_sqsum_clnt_destroy
                 -((_tm_sum_clnt_destroy*_tm_sum_clnt_destroy)
                   /(double)_tm_cnt_clnt_destroy))
                /(double)(_tm_cnt_clnt_destroy-1)),
           "");
  if (_tm_cnt_xdr_free > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4s &%7.4f && %7.4f &%7.4s\\\\\n",
           "~~~~~~xdr\\_free",
           _tm_cnt_xdr_free,
           "","","",
           sqrt((_tm_sqsum_xdr_free
                 -((_tm_sum_xdr_free*_tm_sum_xdr_free)
                   /(double)_tm_cnt_xdr_free))
                /(double)(_tm_cnt_xdr_free-1)),
           sqrt((_tm_sqsum_xdr_free
                 -((_tm_sum_xdr_free*_tm_sum_xdr_free)
                   /(double)_tm_cnt_xdr_free))
                /(double)(_tm_cnt_xdr_free-1)),
           "");
  if (_tm_cnt_basic_ioop > 1)
  {
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~basic\\_ioop",
           _tm_cnt_basic_ioop,
           "","",
           sqrt((_tm_sqsum_basic_ioop
                 -((_tm_sum_basic_ioop*_tm_sum_basic_ioop)
                   /(double)_tm_cnt_basic_ioop))
                /(double)(_tm_cnt_basic_ioop-1)),
           "","","");
  }
  if (_tm_cnt_fork > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~~~fork",
           _tm_cnt_fork,
           "","",
           sqrt((_tm_sqsum_fork
                 -((_tm_sum_fork*_tm_sum_fork)
                   /(double)_tm_cnt_fork))
                /(double)(_tm_cnt_fork-1)),
           "","","");
  if (_tm_cnt_pfsd_ioopdone > 1)
    printf("%-25s &%5d &%7.4s &%7.4s &%7.4f &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~~~pfsd\\_ioopdone",
           _tm_cnt_pfsd_ioopdone,
           "","",
           sqrt((_tm_sqsum_pfsd_ioopdone
                 -((_tm_sum_pfsd_ioopdone*_tm_sum_pfsd_ioopdone)
                   /(double)_tm_cnt_pfsd_ioopdone))
                /(double)(_tm_cnt_pfsd_ioopdone-1)),
           "",
           sqrt((_tm_sqsum_pfsd_ioopdone
                 -((_tm_sum_pfsd_ioopdone*_tm_sum_pfsd_ioopdone)
                   /(double)_tm_cnt_pfsd_ioopdone))
                /(double)(_tm_cnt_pfsd_ioopdone-1)),
           "");
  if (_tm_cnt_pfslib_ioop > 1)
  {
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~pfslib\\_ioop",
           _tm_cnt_pfslib_ioop,
           "",
           sqrt((_tm_sqsum_pfslib_ioop
                 -((_tm_sum_pfslib_ioop*_tm_sum_pfslib_ioop)
                   /(double)_tm_cnt_pfslib_ioop))
                /(double)(_tm_cnt_pfslib_ioop-1)),
           "","","","");
  }
  if (_tm_cnt__ioop > 1)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_ioop",
           _tm_cnt__ioop,
           sqrt((_tm_sqsum__ioop
                 -((_tm_sum__ioop*_tm_sum__ioop)
                   /(double)_tm_cnt__ioop))
                /(double)(_tm_cnt__ioop-1)),
           "","","","","");
  }
  if (_tm_cnt__iowait > 0)
    printf("\\\\[.5\\doubleclinesep]\n\\hline\n");
  if (_tm_cnt_waitpid > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~waitpid",
           _tm_cnt_waitpid,
           "",
           sqrt((_tm_sqsum_waitpid
                 -((_tm_sum_waitpid*_tm_sum_waitpid)
                   /(double)_tm_cnt_waitpid))
                /(double)(_tm_cnt_waitpid-1)),
           "","","","");
  if (_tm_cnt__copy_child_shm > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "~~_copy_child_shm",
           _tm_cnt__copy_child_shm,
           "",
           sqrt((_tm_sqsum__copy_child_shm
                 -((_tm_sum__copy_child_shm*_tm_sum__copy_child_shm)
                   /(double)_tm_cnt__copy_child_shm))
                /(double)(_tm_cnt__copy_child_shm-1)),
           "","","","");
  if (_tm_cnt_pfsd_iowait > 0)
    printf("%-25s &%5d &%7.4s &%7.4f &%7.4s &%7.4s && %7.4f &%7.4s\\\\\n",
           "~~pfsd\\_iowait",
           _tm_cnt_pfsd_iowait,
           "",
           sqrt((_tm_sqsum_pfsd_iowait
                 -((_tm_sum_pfsd_iowait*_tm_sum_pfsd_iowait)
                   /(double)_tm_cnt_pfsd_iowait))
                /(double)(_tm_cnt_pfsd_iowait-1)),
           "","",
           sqrt((_tm_sqsum_pfsd_iowait
                 -((_tm_sum_pfsd_iowait*_tm_sum_pfsd_iowait)
                   /(double)_tm_cnt_pfsd_iowait))
                /(double)(_tm_cnt_pfsd_iowait-1)),
           "");
  if (_tm_cnt__iowait > 0)
  {
    printf("%-25s &%5d &%7.4f &%7.4s &%7.4s &%7.4s && %7.4s &%7.4s\\\\\n",
           "\\_iowait",
           _tm_cnt__iowait,
           sqrt((_tm_sqsum__iowait
                 -((_tm_sum__iowait*_tm_sum__iowait)
                   /(double)_tm_cnt__iowait))
                /(double)(_tm_cnt__iowait-1)),
           "","","","","");
  }
  
  printf("\\end{tabular*}\n\n");

  return;
}


#endif /* TIMING */
