/* ************************************************************************* *
 *                                                                           *
 *    clnt_read.c,v
 *    Client procedures to read from a PFSLib file
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_read.c,v
 *  RCS Date     : 1996/05/29 15:05:16
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_read.c,v 1.2 1996/05/29 15:05:16 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <stdlib.h>
#include <errno.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern ioIDtabel _pfslib_ioidtbl[];
extern long      _pfslib_ioopres;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern long _ioopv        _PH((int op, int fd, struct iovec *iov, int iovcnt, 
                               bool_t ccall));
extern long _ioop         _PH((int op, int fd, char *buffer, u_int nbytes, 
                               bool_t ccall));
extern void pfslib_perror _PH((char *str));
extern long _iowait       _PH((long ioID));
extern long _vectorlength _PH((struct iovec *iov, int iovcnt));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * asynchronous (nonblocking) vector read form a PFSLib file.                *
 * ************************************************************************* */
long _ireadv
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else  /* ANSI_C */
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  return (_ioopv(READV_OP,filedes, iov, iovcnt, FALSE));
}

/* ************************************************************************* *
 * asynchronous (nonblocking) read form a PFSLib file.                       *
 * ************************************************************************* */
long _iread
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else  /* ANSI_C */
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  return (_ioop(READ_OP,filedes, buffer, nbytes, FALSE));
}

/* ************************************************************************* *
 * asynchronous (nonblocking) vector read form a PFSLib file.                *
 * Exit on failure.                                                          *
 * ************************************************************************* */
long ireadv
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else  /* ANSI_C */
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  long ioID;

  if ((ioID = _ireadv(filedes, iov, iovcnt)) < 0)
  {
    pfslib_perror("ireadv()");
    exit (1);
  }

  return(ioID);
}

/* ************************************************************************* *
 * asynchronous (nonblocking) read form a PFSLib file.                       *
 * Exit on failure.                                                          *
 * ************************************************************************* */
long iread
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else  /* ANSI_C */
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  long ioID;

  if ((ioID = _iread(filedes, buffer, nbytes)) < 0)
  {
    pfslib_perror("iread()");
    exit (1);
  }

  return(ioID);
}

/* ************************************************************************* *
 * synchronous (blocking) vector read form a PFSLib file.                    *
 * ************************************************************************* */
long _creadv
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else  /* ANSI_C */
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  long ioID;

  if ((ioID = _ioopv(READV_OP, filedes, iov, iovcnt, TRUE)) < 0 )
    return(-1);

  if (_iowait(ioID) < 0 )
    return(-1);

  return(_pfslib_ioopres);
}

/* ************************************************************************* *
 * synchronous (blocking) read form a PFSLib file.                           *
 * ************************************************************************* */
long _cread
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else  /* ANSI_C */
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  long ioID;

  if ((ioID = _ioop(READ_OP, filedes, buffer, nbytes, TRUE)) < 0 )
    return(-1);

  if (_iowait(ioID) < 0 )
    return(-1);

  return(_pfslib_ioopres);
}

/* ************************************************************************* *
 * synchronous (blocking) vector read form a PFSLib file.                    *
 * Exit on failure.                                                          *
 * ************************************************************************* */
void creadv
#ifdef ANSI_C
(int filedes, struct iovec *iov, int iovcnt)
#else  /* ANSI_C */
(filedes, iov, iovcnt)
int filedes;
struct iovec *iov;
int iovcnt;
#endif /* ANSI_C */
{
  long res;

  if ((res = _creadv(filedes, iov, iovcnt))
      != _vectorlength(iov,iovcnt))
  {
    if (res >= 0) errno = EPFSLNBYTES;
    pfslib_perror("creadv()");
    exit (1);
  }

  return;
}

/* ************************************************************************* *
 * synchronous (blocking) read form a PFSLib file.                           *
 * Exit on failure.                                                          *
 * ************************************************************************* */
void cread
#ifdef ANSI_C
(int filedes, char *buffer, unsigned int nbytes)
#else  /* ANSI_C */
(filedes, buffer, nbytes)
int filedes;
char *buffer;
unsigned int nbytes;
#endif /* ANSI_C */
{
  long res;

  if ((res = _cread( filedes, buffer, nbytes)) != nbytes)
  {
    if (res >= 0) errno = EPFSLNBYTES;
    pfslib_perror("cread()");
    exit (1);
  }

  return;
}

