/* ************************************************************************* *
 *                                                                           *
 *    clnt_lseek.c,v
 *    Client procedures to set the file pointer
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_lseek.c,v
 *  RCS Date     : 1996/05/29 15:05:09
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_lseek.c,v 1.3 1996/05/29 15:05:09 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern int          _pfslib_maxfiles;
extern pfslib_fhdl *_pfslib_ftbl;
extern CLIENT      *_pfslib_clnt;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern void _pfslib_awaitresult  _PH((CLIENT *clnt));
extern void _pfslib_resettimeout _PH((CLIENT *clnt));

#undef _PH

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Move the file pointer of a PFSLib file                                    *
 * ************************************************************************* */
off_t _pfslib_lseek
#ifdef ANSI_C
(int fd, off_t offset, int whence)
#else  /* ANSI_C */
(fd, offset, whence)
int fd;
off_t offset;
int whence;
#endif /* ANSI_C */
{
  lseekres   *result;
  fpmoveargs  arg;
  off_t pos;

  fd -= VFDOFFSET;

  /* Check argument */
  if ((fd < 0) || (fd >= _pfslib_maxfiles) ||
      (_pfslib_ftbl[fd].vfd == -1))
  {
    errno = EPFSLBADF;
    return (-1);
  }

  if ((whence != SEEK_SET) &&
      (whence != SEEK_CUR) &&
      (whence != SEEK_END))
  {
    errno = EPFSLINVAL;
    return (-1);
  }
  

  arg.fh     = _pfslib_ftbl[fd];
  arg.whence = whence;
  arg.offset = offset;

  if ((arg.fh.mode == M_SYNC) || (arg.fh.mode == M_RECORD) ||
      (arg.fh.mode == M_GLOBAL))
    _pfslib_awaitresult(_pfslib_clnt);

  if ((result = pfsd_lseek_1(&arg, _pfslib_clnt)) == NULL)
  {
    clnt_perror(_pfslib_clnt, "_pfslib_lseek(): pfsd_lseek_1()");
    return(-1);
  }

  _pfslib_resettimeout(_pfslib_clnt);

  ERR_RESULT(lseekres_u, xdr_lseekres);
  
  pos = (off_t)result->lseekres_u.pos;

  xdr_free(xdr_lseekres, (char *)result);

  return (pos);
}

/* ************************************************************************* *
 * Move the file pointer of a PFSLib file or a normal file.                  *
 * ************************************************************************* */
off_t pfslib_lseek
#ifdef ANSI_C
(int filedes, off_t offset, int whence)
#else  /* ANSI_C */
(filedes, offset, whence)
int filedes;
off_t offset;
int whence;
#endif /* ANSI_C */
{
  if (filedes >= VFDOFFSET)
    return (_pfslib_lseek(filedes, offset, whence));
  else
    return (lseek(filedes, offset, whence));
}
