/* ************************************************************************* *
 *                                                                           *
 *    clnt_islocal.c,v
 *    Client procedures to test whether a host is the local host
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_islocal.c,v
 *  RCS Date     : 1996/05/28 15:53:45
 *  RCS Revision : 1.3
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_islocal.c,v 1.3 1996/05/28 15:53:45 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "global.h"
#include "rpc_defaults.h"

/* ************************************************************************* *
 * Global variable
 * ************************************************************************* */

typedef char IPA[IPADDRLEN];

static IPA *myipaddrs = NULL;
static int myipaddrcnt = 0;

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Get the list of IP addresses of the local machine                         *
 * ************************************************************************* */
int _get_my_ipaddr
#ifdef ANSI_C
(void)
#else  /* ANSI_C */
()
#endif /* ANSI_C */
{
  char hostname[MAXNLEN];
  struct hostent *hp;
  struct in_addr ia;
  int i;
  
  if (gethostname(hostname,MAXNLEN) < 0)
  {
    perror("_get_my_ipaddr(): gethostname()");
    return (-1);
  }
  
  if ((hp = gethostbyname(hostname)) == NULL)
  {
    perror("_get_my_ipaddr(): gethostbyname()");
    return (-1);
  }
  
  for (i=0; hp->h_addr_list[i] != NULL; i++, myipaddrcnt++)
  {
    if (myipaddrcnt == 0)
    {
      if ((myipaddrs = malloc(sizeof(IPA))) == NULL)
      {
        perror("_get_my_ipaddr(): malloc()");
        return (-1);
      }
    }
    else if ((myipaddrs = realloc(myipaddrs,
                                  (myipaddrcnt+1)*sizeof(IPA))) == NULL)
    {
      perror("_get_my_ipaddr(): realloc()");
      return (-1);
    }
    
    memcpy(&ia,hp->h_addr_list[i],(size_t)hp->h_length);
    strcpy(myipaddrs[myipaddrcnt],inet_ntoa(ia));
  }    

#ifdef LOCAL_ATM_IF
  strcat(hostname,ATM_NAME_EXT);
  
  if ((hp = gethostbyname(hostname)) == NULL)
    return (0);                 /* No host with Name extention */
  
  for (i=0; hp->h_addr_list[i] != NULL; i++, myipaddrcnt++)
  {
    if (myipaddrcnt == 0)
    {
      if ((myipaddrs = malloc(sizeof(IPA))) == NULL)
      {
        perror("_get_my_ipaddr(): malloc()");
        return (-1);
      }
    }
    else if ((myipaddrs = realloc(myipaddrs,
                                  (myipaddrcnt+1)*sizeof(IPA))) == NULL)
    {
      perror("_get_my_ipaddr(): realloc()");
      return (-1);
    }
    
    memcpy(&ia,hp->h_addr_list[i],(size_t)hp->h_length);
    strcpy(myipaddrs[myipaddrcnt],inet_ntoa(ia));
  }    
#endif
  return(myipaddrcnt);
}

/* ************************************************************************* *
 * Check whether a IP address is the local machine.                          *
 * ************************************************************************* */
int _pfslib_islocal
#ifdef ANSI_C
(char *ipaddr)
#else  /* ANSI_C */
(ipaddr)
char *ipaddr;
#endif /* ANSI_C */
{
  int i;

  for (i = 0; i < myipaddrcnt ; i++)
  {
    if (strcmp(ipaddr,myipaddrs[i]) == 0)
      return (1);
  }

  return (0);
}

    

  

