/* ************************************************************************* *
 *                                                                           *
 *    clnt_iowait.c,v
 *    Client procedures to wait for the termination of an IO operation
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_iowait.c,v
 *  RCS Date     : 1996/10/18 14:40:01
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_iowait.c,v 1.5 1996/10/18 14:40:01 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include "pfsd.h"
#include "clnt_defines.h"
#include "clnt_macros.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */

extern ioIDtabel    _pfslib_ioidtbl[];
extern pfslib_fhdl *_pfslib_ftbl;
extern CLIENT      *_pfslib_clnt;
extern long         _pfslib_ioopres;

#ifdef ANSI_C
#define _PH(a) a
#else  /* ANSI_C */
#define _PH(a) ()
#endif /* ANSI_C */

extern int  _copy_child_shm      _PH((long ioID));
extern void _pfslib_awaitresult  _PH((CLIENT *clnt));
extern void _pfslib_resettimeout _PH((CLIENT *clnt));
extern void pfslib_perror        _PH((char *str));

#undef _PH

/* ************************************************************************* *
 * Wait for the completion of an asynchronous IO operation.                  *
 *   If there is a child process for the operation wait for its termination  *
 *   Wait for termiation at pfsd                                             *
 * ************************************************************************* */
long _iowait
#ifdef ANSI_C
(long ioID)
#else  /* ANSI_C */
(ioID)
long ioID;
#endif /* ANSI_C */
{
  ioopres      *result;
  ioidstatargs  arg;

  int state;

  S_TIME(_iowait);

  /* 
   * input correct?
   */

  if ((ioID < 0) || (ioID >= MAXIOID) ||
      ((_IDTE.state != IDT_DONE) && (_IDTE.state != IDT_PENDING)) ||
      ((_IDTE.state == IDT_PENDING) && (_IDTE.csync)))
  {
    errno  = EPFSLBADID;
    return (-1);
  }
  
  if (_IDTE.state != IDT_DONE)
  {
    if (_IDTE.childpid == -1)
    {
      errno = EPFSLNOCHLD;
      return (-1);
    }

    S_TIME(waitpid);
    if (waitpid(_IDTE.childpid,&state,0) != _IDTE.childpid)
    {
      perror("_iowait(): waitpid()");
      return (-1);
    }
    E_TIME(waitpid);
 
    if (WIFSIGNALED(state) || WIFEXITED(state))
    {
      _IDTE.childpid  = -1;
      _IDTE.state     = IDT_DONE;
      _IDTE.childexit = state;

      S_TIME(_copy_child_shm);
      if ((!WIFSIGNALED(state)) && (WEXITSTATUS(state) == 0))
        if (_copy_child_shm(ioID) < 0)
        {
          return (-1);
        }
      E_TIME(_copy_child_shm);
    }
  }

  if (!_IDTE.csync)
  {
    if (WIFSIGNALED(_IDTE.childexit))
    {
      errno = EPFSLCHLDSIG;
      return (-1);
    }
    
    if (WEXITSTATUS(_IDTE.childexit) != 0)
    {
      errno = EPFSLCHLDEXIT;
      return (-1);
    }
  }
  
  arg.fh = _pfslib_ftbl[_IDTE.fd];
  arg.ioID = _IDTE.svrioID;

  _pfslib_awaitresult(_pfslib_clnt);

  S_TIME(pfsd_iowait);
  if ((result = pfsd_iowait_1(&arg,_pfslib_clnt)) == NULL )
  {
    clnt_perror(_pfslib_clnt, "_iowait(): pfsd_iowait_1()");
    return (-1);
  }
  E_TIME(pfsd_iowait);

  _pfslib_resettimeout(_pfslib_clnt);

  ERR_RESULT(ioopres_u, xdr_ioopres);

  _pfslib_ioopres = result->ioopres_u.res.res;
  errno = result->ioopres_u.res.errno;

  xdr_free(xdr_ioopres, (char *)result);

  _IDTE.state = IDT_UNUSED;
  _IDTE.childpid = -1;
  _IDTE.shmid    = -1;

  E_TIME(_iowait);

  if (_pfslib_ioopres < 0)
    return (-1);
  else
    return (0);
}

/* ************************************************************************* *
 * Wait for the completion of an asynchronous IO operation.                  *
 * Exit on failure                                                           *
 * ************************************************************************* */
void iowait
#ifdef ANSI_C
(int ioID)
#else  /* ANSI_C */
(ioID)
int ioID;
#endif /* ANSI_C */
{
  if (_iowait(ioID) < 0 )
  {
    pfslib_perror("iowait()");
    exit (1);
  }

  return;
}
