/* ************************************************************************* *
 *                                                                           *
 *    clnt_error.c,v
 *    Client procedures to print PFSLib error messages 
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_error.c,v
 *  RCS Date     : 1996/04/24 14:25:09
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "clnt_error.c,v 1.1 1996/04/24 14:25:09 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */
#include <stdio.h>
#include <errno.h>

#define PFSLIB_ERRORDEF
#include "global.h"
#include "pfslib_errno.h"

/* ************************************************************************* *
 * External declarations                                                     *
 * ************************************************************************* */
extern int   sys_nerr;
extern char *sys_errlist[];

/* ************************************************************************* *
 * Global valiables
 * ************************************************************************* */
int  pfslib_rerrno;
char pfslib_rerrstr[MAXERRLEN];

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * Prinf a system error message or a PFSLib error message.                   *
 * ************************************************************************* */
void pfslib_perror
#ifdef ANSI_C
(char *str)
#else  /* ANSI_C */
(str)
char *str;
#endif /* ANSI_C */
{
  if ((errno >=0) && (errno < sys_nerr))
  {
    perror(str);
    return;
  }
  if (errno == EPFSLREMOTE)
  {
    fprintf(stderr,"%s: %s: %s\n", str, pfslib_errlist[EPFSLREMOTE-PFSLERR],
            pfslib_rerrstr);
    return;
  }
  if ((errno > PFSLERR) && (errno <= PFSLMAXERR))
  {
    fprintf(stderr,"%s: %s\n", str, pfslib_errlist[errno-PFSLERR]);
    return;
  }
  
  fprintf(stderr,"%s: Unkown error: %d\n",str,errno);
  return;
}
