/* ************************************************************************* *
 *                                                                           *
 *    clnt_defines.h,v
 *    Client specific definitions
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : clnt_defines.h,v
 *  RCS Date     : 1996/04/24 14:25:07
 *  RCS Revision : 1.1
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef __pfslib_clnt_defines_h__
#define __pfslib_clnt_defines_h__
#ifndef lint
static void *rcs_id_clnt_defines = "clnt_defines.h,v 1.1 1996/04/24 14:25:07 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <sys/types.h>
#include <sys/uio.h>

/* ************************************************************************* *
 * Definitions
 * ************************************************************************* */

#define VFDOFFSET     1024      /* virtual file descriptor offset */

#define S_DFLTIOLEN (16*1024+1) /* dflt. length to fork() an IO-Server */
#define C_DFLTIOLEN (32*1024+1) /* dflt. length to fork() an IO-Client */

#define MAXIOID     20          /* Max number of io id's */

enum clt_iostate
{
  IDT_UNUSED,
  IDT_USED,
  IDT_PENDING,
  IDT_DONE,
  IDT_FAILED
};
typedef enum clt_iostate clt_iostate;

struct ioIDtabel
{
  clt_iostate   state;          /* current state */
  int           errno;          /* Error number if failed */
  int           fd;             /* File descriptor */
  int           op;             /* What kind of IO operation */
  long          iolen;          /* number of bytes to transmit */
  bool_t        csync;          /* Client asynchron */
  char         *buffer;         /* buffer */
  struct iovec *iov;            /* io vector */
  int           iovcnt;         /* length of io vector */
  pid_t         childpid;       /* pid of child process if any */
  int           childexit;      /* exit status of child */
  int           shmid;          /* shared memory id if any */
  int           svrioID;        /* ioID at pfsd */
};
typedef struct ioIDtabel ioIDtabel;



#endif /* ___pfslib_clnt_defines_h__ */
