/* ************************************************************************* *
 *                                                                           *
 *    add_xdr.c,v
 *    Procedures for XDR data conversion
 *                                                                           *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder          *
 *                                                                           *
 *    PFSLib (Parallel I/O on workstations)                                  *
 *                                                                           *
 *    PFSLib offers parallel access to files for a parallel application      *
 *    running on a cluster of workstations.                                  *
 *    It is intended but not restricted to be used in message passing        *
 *    applications based on PVM, NXLib, MPI, and other.                      *
 *                                                                           *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.   *
 *                                                                           *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or       *
 *    modify it under the terms of the GNU Library General Public            *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS          *
 *    and/or modify them under the terms of the GNU General Public           *
 *    License as published by the Free Software Foundation; either           *
 *    version 2 of the License, or (at your option) any later version.       *
 *                                                                           *
 *    PFSLib is distributed in the hope that it will be useful,              *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *    Library General Public License and GNU General Public License          *
 *    for more details.                                                      *
 *                                                                           *
 *    You should have received a copy of the GNU Library General Public      *
 *    License and the GNU General Public License along with this             *
 *    library; if not, write to the Free                                     *
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     *
 *                                                                           *
 *    Contact to the authors:                                                *
 *                                                                           *
 *    electronic mail: pfslib@informatik.tu-muenchen.de                      *
 *                                                                           *
 *    paper mail:      Prof. Dr. A. Bode                                     *
 *                     Lehrstuhl f"ur Rechnertechnik und                     *
 *                     Rechnerorganisation                                   *
 *                     Institut f"ur Informatik                              *
 *                     Technische Universit"at M"unchen                      *
 *                     80290 M"unchen                                        *
 *                     Germany                                               *
 *                                                                           *
 *    This project was partially funded by a research grant form Intel       *
 *    Corporation.                                                           *
 *                                                                           *
 * ************************************************************************* */


/* ************************************************************************* *
 *                                                                           *
 *  RCS Filename : add_xdr.c,v
 *  RCS Date     : 1996/05/29 14:57:58
 *  RCS Revision : 1.2
 *  RCS Author   : lamberts
 *  RCS State    : V2_0_B
 *                                                                           *
 *  Authors: Stefan Lamberts, Christian R"oder                               *
 *                                                                           *
 * ************************************************************************* */
#ifndef lint
static void *rcs_id = "add_xdr.c,v 1.2 1996/05/29 14:57:58 lamberts V2_0_B";
#endif

/* ************************************************************************* *
 * Include files                                                             *
 * ************************************************************************* */

#include <rpc/rpc.h>
#include <fcntl.h>

#include "pfsd.h"

/* ************************************************************************* *
 * Procedures                                                                *
 * ************************************************************************* */

/* ************************************************************************* *
 * xdr routine to convert open flags in a machine independent format         *
 * ************************************************************************* */
bool_t xdr_pfslib_otype
#ifdef ANSI_C
(XDR *xdrs, pfslib_otype *objp)
#else
(xdrs, objp)
XDR *xdrs;
pfslib_otype *objp;
#endif /* ANSI_C */
{
  int res = 0;
  
  switch (xdrs->x_op)
  {
  case XDR_ENCODE:
    if (*objp & O_RDONLY) res |= PFSLIB_O_RDONLY;
    if (*objp & O_WRONLY) res |= PFSLIB_O_WRONLY;
    if (*objp & O_RDWR) res |= PFSLIB_O_RDWR;
    if (*objp & O_APPEND) res |= PFSLIB_O_APPEND;
    if (*objp & O_CREAT) res |= PFSLIB_O_CREAT;
    if (*objp & O_EXCL) res |= PFSLIB_O_EXCL;
    if (*objp & O_NOCTTY) res |= PFSLIB_O_NOCTTY;
    if (*objp & O_NONBLOCK) res |= PFSLIB_O_NONBLOCK;
    if (*objp & O_TRUNC) res |= PFSLIB_O_TRUNC;
    if (*objp & O_NDELAY) res |= PFSLIB_O_NDELAY;
    if (*objp & O_SYNC) res |= PFSLIB_O_SYNC;
    return (xdr_int(xdrs, &res));
  case XDR_DECODE:
    if (!xdr_int(xdrs, &res))
    {
      return (FALSE);
    }
    *objp = 0;
    if (res & PFSLIB_O_RDONLY) *objp |= O_RDONLY;
    if (res & PFSLIB_O_WRONLY) *objp |= O_WRONLY;
    if (res & PFSLIB_O_RDWR) *objp |= O_RDWR;
    if (res & PFSLIB_O_APPEND) *objp |= O_APPEND;
    if (res & PFSLIB_O_CREAT) *objp |= O_CREAT;
    if (res & PFSLIB_O_EXCL) *objp |= O_EXCL;
    if (res & PFSLIB_O_NOCTTY) *objp |= O_NOCTTY;
    if (res & PFSLIB_O_NONBLOCK) *objp |= O_NONBLOCK;
    if (res & PFSLIB_O_TRUNC) *objp |= O_TRUNC;
    if (res & PFSLIB_O_NDELAY) *objp |= O_NDELAY;
    if (res & PFSLIB_O_SYNC) *objp |= O_SYNC;
    return (TRUE);
  case XDR_FREE:
    return (xdr_int(xdrs, &res));
  }
  return (FALSE);
}


#ifdef NO_XDR_DIST_LIST

bool_t xdr_DIST_LIST
#ifdef ANSI_C
(XDR *xdrs, DIST_LIST *objp)
#else  /* ANSI_C */
(xdrs, objp)
XDR *xdrs;
DIST_LIST *objp;
#endif /* ANSI_C */
{
  switch (xdrs->x_op)
  {
  case XDR_ENCODE:
  case XDR_FREE:
    objp->DIST_LIST_len *= sizeof(DIST_LIST_EL);
    break;
  case XDR_DECODE:
    break;
  }    
  if (!xdr_bytes(xdrs, (char **)&objp->DIST_LIST_val, (u_int *)&objp->DIST_LIST_len, ~0)) {
    return (FALSE);
  }
  switch (xdrs->x_op)
  {
  case XDR_ENCODE:
  case XDR_FREE:
    break;
  case XDR_DECODE:
    objp->DIST_LIST_len /= sizeof(DIST_LIST_EL);
    break;
  }
  
  return (TRUE);
}

#endif /* NO_XDR_DIST_LIST */
