/*
 * tcp_setup.h
 * june 1995
 * sandeep gupta
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: tcp_setup.h,v 1.7 1995/08/22 21:27:49 tuna Exp $
 */

/*
 * This is the header file included by all the tcp_* files and contains
 * prototypes and structures internal to the TCP/UNIX code.
 */

#ifndef _TCP_SETUP_H_
#define _TCP_SETUP_H_

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <string.h>
#include <sys/ioctl.h>

extern int TCP_interrupt_status(void);
extern int crl_sigblock(int);
extern int crl_sigsetmask(int);

#define MESSAGE_SIZE (576)
#define FALSE        (0)

typedef void (*handler)();

extern void tcp_setup(void);
extern void tcp_shutdown(void);
extern void tcp_am_send(int, handler, int, char *);
extern void tcp_am_handler(void);

/* tcp_am_send_cm() should really be declared as
 *
 *   extern void tcp_am_send_cm(int, handler, int, int, int, int)
 *
 * but this would make it difficult to call it with other than four
 * data arguments (the four trailing "int"s), as is possible with the
 * CM-5 active message functions. so we take the lazy way out and
 * declare tcp_am_send_cm() with an old-style C function declaration
 * that doesn't include argument types and trust that people will
 * always call it with correctly-typed arguments.
 */
extern void tcp_am_send_cm();

extern fd_set readfds, writefds, exceptfds;
extern int    maxfds;
extern int    shuttingdown;

#endif _TCP_SETUP_H_
