/*
 * tcp_error.c
 * june 1995
 * sandeep gupta
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: tcp_error.c,v 1.8 1995/08/22 21:27:49 tuna Exp $
 */

 /*
  * This file contains error functions used by the TCP/UNIX version of CRL.
  */

#include <stdio.h>
#include <varargs.h>
#include "crl.h"

extern int   errno;		/* Unix error number */
extern int   sys_nerr;		/* # of error message strings in sys table */
extern char *sys_errlist[];	/* the system error message table */

char *pname = NULL;

void my_perror(void);

void err_quit(va_alist)
va_dcl
{
  va_list args;
  char   *fmt;
  
  va_start(args);
  if (pname != NULL)
    fprintf(stderr, "%s: ", pname);
  fmt = va_arg(args, char *);
  vprintf(stderr, fmt, args);
  fputc('\n', stderr);
  va_end(args);
  
  exit(1);
}


void err_system(va_alist)
va_dcl
{
  va_list args;
  char   *fmt;
  char   *file;
  long    lineno;

  va_start(args);
  fprintf(stderr, "CRL version %s: ", CRL_VERSION);
  file = va_arg(args, char *);
  lineno = va_arg(args, long);
  fprintf(stderr, "error in file %s at line number %ld\n",file,lineno);
  fmt = va_arg(args, char *);
  vfprintf(stderr, fmt, args);
  va_end(args);

  my_perror();

  exit(1);
}


char *sys_err_str(void)
{
  static char msgstr[200];

  if (errno != 0)
  {
    if ((errno > 0) && (errno < sys_nerr))
      sprintf(msgstr, "(%s)", sys_errlist[errno]);
    else
      sprintf(msgstr, "(errno = %d)", errno);
  }
  else
  {
    msgstr[0] = '\0';
  }

  return msgstr;
}


/* print the UNIX errno value
 */
void my_perror(void)
{
  fprintf(stderr, " %s\n", sys_err_str());
}
