/*
 * crl.h
 * kirk johnson
 * january 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: crl.h,v 1.8 1995/08/22 21:27:49 tuna Exp $
 */

 /* This is the header file which CRL applications should include.  It
  * contains prototypes for only those functions which applications
  * should use.
  */

#ifndef _CRL_H_
#define _CRL_H_

#define CRL_VERSION "1.0"

typedef unsigned rid_t;

extern unsigned crl_self_addr;
extern unsigned crl_num_nodes;

#if defined(TCPUNIX)
extern void     crl_init(char *);
extern void     crl_exit(void);
#else
extern void     crl_init(void);
#endif

extern rid_t    rgn_create(unsigned);
extern void     rgn_destroy(rid_t);
extern void    *rgn_map(rid_t);
extern void     rgn_unmap(void *);

extern rid_t    rgn_rid(void *);
extern unsigned rgn_size(void *);

extern void     rgn_start_read(void *);
extern void     rgn_end_read(void *);
extern void     rgn_start_write(void *);
extern void     rgn_end_write(void *);
extern void     rgn_flush(void *);

extern void     rgn_barrier(void);
extern void     rgn_bcast_send(int, void *);
extern void     rgn_bcast_recv(int, void *);
extern double   rgn_reduce_dadd(double);
extern double   rgn_reduce_dmin(double);
extern double   rgn_reduce_dmax(double);

extern void     crl_stats_reset(void);
extern void     crl_stats_print(void);

#endif
