/*
 * cm5_sync.c
 * kirk johnson
 * january 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: cm5_sync.c,v 1.4 1995/08/22 21:27:49 tuna Exp $
 */

#include "crl_int.h"


void init_sync(void)
{
  /* nothing */
}


void rgn_barrier(void)
{
  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    CMMD_sync_with_nodes();
    CMAML_disable_interrupts();
  }
  else
  {
    CMMD_sync_with_nodes();
  }
}


void rgn_bcast_send(int len, void *buf)
{
  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    CMMD_bc_to_nodes(buf, len);
    CMAML_disable_interrupts();
  }
  else
  {
    CMMD_bc_to_nodes(buf, len);
  }
}


void rgn_bcast_recv(int len, void *buf)
{
  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    CMMD_receive_bc_from_node(buf, len);
    CMAML_disable_interrupts();
  }
  else
  {
    CMMD_receive_bc_from_node(buf, len);
  }
}


double rgn_reduce_dadd(double x)
{
  double rslt;

  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    rslt = CMMD_reduce_double(x, CMMD_combiner_dadd);
    CMAML_disable_interrupts();
  }
  else
  {
    rslt = CMMD_reduce_double(x, CMMD_combiner_dadd);
  }

  return rslt;
}


double rgn_reduce_dmin(double x)
{
  double rslt;

  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    rslt = CMMD_reduce_double(x, CMMD_combiner_dmin);
    CMAML_disable_interrupts();
  }
  else
  {
    rslt = CMMD_reduce_double(x, CMMD_combiner_dmin);
  }

  return rslt;
}


double rgn_reduce_dmax(double x)
{
  double rslt;

  if (CMAML_interrupt_status() == FALSE)
  {
    CMAML_enable_interrupts();
    rslt = CMMD_reduce_double(x, CMMD_combiner_dmax);
    CMAML_disable_interrupts();
  }
  else
  {
    rslt = CMMD_reduce_double(x, CMMD_combiner_dmax);
  }

  return rslt;
}
