/*
 * cm5_fast_data.c
 * february 1995
 * kirk johnson
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: cm5_fast_data.c,v 1.4 1995/08/22 21:27:49 tuna Exp $
 */

#include "crl_int.h"

extern void rgn_msg_stub(unsigned, Region *, unsigned, unsigned);

static void fast_data_control(unsigned, Region *, unsigned, unsigned);
static void fast_data_last_1(Region *, unsigned, unsigned);
static void fast_data_last_2(Region *, unsigned, unsigned, unsigned);
static void fast_data_00(Region *, unsigned, unsigned, unsigned);
static void fast_data_03(Region *, unsigned, unsigned, unsigned);
static void fast_data_06(Region *, unsigned, unsigned, unsigned);
static void fast_data_09(Region *, unsigned, unsigned, unsigned);
static void fast_data_12(Region *, unsigned, unsigned, unsigned);
static void fast_data_15(Region *, unsigned, unsigned, unsigned);
static void fast_data_18(Region *, unsigned, unsigned, unsigned);
static void fast_data_21(Region *, unsigned, unsigned, unsigned);
static void fast_data_24(Region *, unsigned, unsigned, unsigned);
static void fast_data_27(Region *, unsigned, unsigned, unsigned);
static void fast_data_30(Region *, unsigned, unsigned, unsigned);
static void fast_data_33(Region *, unsigned, unsigned, unsigned);
static void fast_data_36(Region *, unsigned, unsigned, unsigned);
static void fast_data_39(Region *, unsigned, unsigned, unsigned);
static void fast_data_42(Region *, unsigned, unsigned, unsigned);
static void fast_data_45(Region *, unsigned, unsigned, unsigned);
static void fast_data_48(Region *, unsigned, unsigned, unsigned);
static void fast_data_51(Region *, unsigned, unsigned, unsigned);
static void fast_data_54(Region *, unsigned, unsigned, unsigned);
static void fast_data_57(Region *, unsigned, unsigned, unsigned);
static void fast_data_60(Region *, unsigned, unsigned, unsigned);
static void fast_data_63(Region *, unsigned, unsigned, unsigned);
static void fast_data_66(Region *, unsigned, unsigned, unsigned);
static void fast_data_69(Region *, unsigned, unsigned, unsigned);
static void fast_data_72(Region *, unsigned, unsigned, unsigned);
static void fast_data_75(Region *, unsigned, unsigned, unsigned);
static void fast_data_78(Region *, unsigned, unsigned, unsigned);
static void fast_data_81(Region *, unsigned, unsigned, unsigned);
static void fast_data_84(Region *, unsigned, unsigned, unsigned);
static void fast_data_87(Region *, unsigned, unsigned, unsigned);
static void fast_data_90(Region *, unsigned, unsigned, unsigned);
static void fast_data_93(Region *, unsigned, unsigned, unsigned);
static void fast_data_96(Region *, unsigned, unsigned, unsigned);

void *fast_data_handlers[] =
{
  (void *) fast_data_00, (void *) fast_data_03, (void *) fast_data_06,
  (void *) fast_data_09, (void *) fast_data_12, (void *) fast_data_15,
  (void *) fast_data_18, (void *) fast_data_21, (void *) fast_data_24,
  (void *) fast_data_27, (void *) fast_data_30, (void *) fast_data_33,
  (void *) fast_data_36, (void *) fast_data_39, (void *) fast_data_42,
  (void *) fast_data_45, (void *) fast_data_48, (void *) fast_data_51,
  (void *) fast_data_54, (void *) fast_data_57, (void *) fast_data_60,
  (void *) fast_data_63, (void *) fast_data_66, (void *) fast_data_69,
  (void *) fast_data_72, (void *) fast_data_75, (void *) fast_data_78,
  (void *) fast_data_81, (void *) fast_data_84, (void *) fast_data_87,
  (void *) fast_data_90, (void *) fast_data_93, (void *) fast_data_96,
};


void fast_data_msg(unsigned node, unsigned type, Region *dst,
		   unsigned vers, Region *src)
{
  int       i;
  int       nwords;
  unsigned *srcbuf;
  void    **hndlrs;

  CMAML_rpc(node, fast_data_control, type,
	    dst, crl_self_addr, vers);

  nwords = (src->size + 0x3) >> 2;
  srcbuf = UserFromMeta(src);
  hndlrs = fast_data_handlers;

  for (i=0; i<(nwords-2); i+=3)
  {
    CMAML_rpc(node, *hndlrs, dst, srcbuf[0], srcbuf[1], srcbuf[2]);
    srcbuf += 3;
    hndlrs += 1;    
  }

  nwords -= i;
  if (nwords == 1)
    CMAML_rpc(node, fast_data_last_1, dst, i, srcbuf[0]);
  else if (nwords == 2)
    CMAML_rpc(node, fast_data_last_2, dst, i, srcbuf[0], srcbuf[1]);
  else
    sanity(nwords == 0);
}


static void fast_data_control(unsigned type, Region *rgn, unsigned src, unsigned vers)
{
  unsigned rip;

  rip = rgn->recv_in_progress;

  if (rip == 0)
  {
    /* we're the first packet to arrive; stash away protocol handler
     * args and initialize recv_in_progress to expected number of
     * words
     */
    rgn->recv_type = type;
    rgn->recv_src  = src;
    rgn->recv_vers = vers;
    rgn->recv_in_progress = (rgn->size + 0x3) >> 2;
  }
  else if (rip > 1)
  {
    /* we're neither the first nor the last packet to arrive; stash
     * away protocol handler args and update recv_in_progress
     */
    rgn->recv_type = type;
    rgn->recv_src  = src;
    rgn->recv_vers = vers;
    rgn->recv_in_progress = rip - 1;
  }
  else
  {
    /* we're the last packet to arrive; invoke protocol handler
     */
    rgn->recv_in_progress = 0;
    rgn_msg_stub(type, rgn, src, vers);
  }
}


static void fast_data_last_1(Region *rgn, unsigned ofs, unsigned d0)
{
  unsigned type;
  unsigned src;
  unsigned vers;
  unsigned rip;

  ((unsigned *) UserFromMeta(rgn))[ofs] = d0;

  rip = rgn->recv_in_progress;

  if (rip > 1)
  {
    /* we're neither the first nor the last packet to arrive;
     * update recv_in_progress
     */
    rgn->recv_in_progress = rip - 1;
  }
  else if (rip == 1)
  {
    /* we're the last packet to arrive; invoke protocol handler
     */
    type = rgn->recv_type;
    src  = rgn->recv_src;
    vers = rgn->recv_vers;
    rgn->recv_in_progress = 0;
    rgn_msg_stub(type, rgn, src, vers);
  }
  else
  {
    sanity(rip == 0);

    /* we're the first packet to arrive; initialize recv_in_progress
     * to expected number of words less one (for this packet) plus
     * one (for the control packet)
     */
    rgn->recv_in_progress = ((rgn->size + 0x3) >> 2);
  }
}


static void fast_data_last_2(Region *rgn, unsigned ofs, unsigned d0, unsigned d1)
{
  unsigned type;
  unsigned src;
  unsigned vers;
  unsigned rip;

  ((unsigned *) UserFromMeta(rgn))[(ofs)+0] = d0;
  ((unsigned *) UserFromMeta(rgn))[(ofs)+1] = d1;

  rip = rgn->recv_in_progress;

  if (rip > 2)
  {
    /* we're neither the first nor the last packet to arrive;
     * update recv_in_progress
     */
    rgn->recv_in_progress = rip - 2;
  }
  else if (rip == 2)
  {
    /* we're the last packet to arrive; invoke protocol handler
     */
    type = rgn->recv_type;
    src  = rgn->recv_src;
    vers = rgn->recv_vers;
    rgn->recv_in_progress = 0;
    rgn_msg_stub(type, rgn, src, vers);
  }
  else
  {
    sanity(rip == 0);

    /* we're the first packet to arrive; initialize recv_in_progress
     * to expected number of words less two (for this packet) plus
     * one (for the control packet)
     */
    rgn->recv_in_progress = ((rgn->size + 0x3) >> 2) - 1;
  }
}


static void fast_data_common(Region *rgn)
{
  unsigned type;
  unsigned src;
  unsigned vers;
  unsigned rip;

  rip = rgn->recv_in_progress;

  if (rip > 3)
  {
    /* we're neither the first nor the last packet to arrive;
     * update recv_in_progress
     */
    rgn->recv_in_progress = rip - 3;
  }
  else if (rip == 3)
  {
    /* we're the last packet to arrive; invoke protocol handler
     */
    type = rgn->recv_type;
    src  = rgn->recv_src;
    vers = rgn->recv_vers;
    rgn->recv_in_progress = 0;
    rgn_msg_stub(type, rgn, src, vers);
  }
  else
  {
    sanity(rip == 0);

    /* we're the first packet to arrive; initialize recv_in_progress
     * to expected number of words less three (for this packet) plus
     * one (for the control packet)
     */
    rgn->recv_in_progress = ((rgn->size + 0x3) >> 2) - 2;
  }
}



#define fast_data_body(ofs)                      \
 ((unsigned *) UserFromMeta(rgn))[(ofs)+0] = d0; \
 ((unsigned *) UserFromMeta(rgn))[(ofs)+1] = d1; \
 ((unsigned *) UserFromMeta(rgn))[(ofs)+2] = d2; \
 fast_data_common(rgn)

static void fast_data_00(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(0); }

static void fast_data_03(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(3); }

static void fast_data_06(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(6); }

static void fast_data_09(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(9); }

static void fast_data_12(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(12); }

static void fast_data_15(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(15); }

static void fast_data_18(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(18); }

static void fast_data_21(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(21); }

static void fast_data_24(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(24); }

static void fast_data_27(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(27); }

static void fast_data_30(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(30); }

static void fast_data_33(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(33); }

static void fast_data_36(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(36); }

static void fast_data_39(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(39); }

static void fast_data_42(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(42); }

static void fast_data_45(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(45); }

static void fast_data_48(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(48); }

static void fast_data_51(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(51); }

static void fast_data_54(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(54); }

static void fast_data_57(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(57); }

static void fast_data_60(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(60); }

static void fast_data_63(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(63); }

static void fast_data_66(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(66); }

static void fast_data_69(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(69); }

static void fast_data_72(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(72); }

static void fast_data_75(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(75); }

static void fast_data_78(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(78); }

static void fast_data_81(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(81); }

static void fast_data_84(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(84); }

static void fast_data_87(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(87); }

static void fast_data_90(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(90); }

static void fast_data_93(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(93); }

static void fast_data_96(Region *rgn, unsigned d0, unsigned d1, unsigned d2)
{ fast_data_body(96); }
