/*
 * crl.h
 * kirk johnson
 * january 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: crl.h,v 1.5 1995/08/22 21:27:49 tuna Exp $
 */

#ifndef _CRL_H_
#define _CRL_H_

/* make sure we've got assert()
 */
#include <assert.h>

/* #define something to let applications figure out whether or not
 * they're being compiled against the null version of CRL
 */
#define NULLCRL

typedef unsigned rid_t;

extern unsigned crl_self_addr;
extern unsigned crl_num_nodes;

extern void  crl_init(void);
extern rid_t rgn_create(unsigned);

#define rgn_destroy(rgn_id)       /* nothing */
#define rgn_map(rgn_id)           ((void *) (rgn_id))
#define rgn_unmap(x)              /* nothing */
#define rgn_rid(x)                ((rid_t) (x))
#define rgn_size(x)               (*((unsigned *) (((char *) (x)) - 8)))
#define rgn_start_read(x)         /* nothing */
#define rgn_end_read(x)           /* nothing */
#define rgn_start_write(x)        /* nothing */
#define rgn_end_write(x)          /* nothing */
#define rgn_flush(x)              /* nothing */
#define rgn_barrier()             /* nothing */
#define rgn_bcast_send(len, buf)  /* nothing */
#define rgn_bcast_recv(len, buf)  assert(0)
#define rgn_reduce_dadd(x)        (x)
#define rgn_reduce_dmin(x)        (x)
#define rgn_reduce_dmax(x)        (x)

#define safe_malloc(x)            (malloc(x))
#define safe_free(x)              (free(x))

#define crl_flush_urc()           /* nothing */
#define crl_prof_reset()          /* nothing */
#define crl_prof_print()          /* nothing */

#endif
