/*
 * crl.c
 * kirk johnson
 * january 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: crl.c,v 1.4 1995/08/22 21:27:49 tuna Exp $
 */

#include <stdio.h>
#include <stdlib.h>

#if defined(CM5)
#include <cm/cmmd.h>
#define assert(x)                                  \
 do {                                              \
  if (!(x))                                        \
    CMMD_error("pn %d: failed assertion, %s:%d\n", \
	       crl_self_addr, __FILE__, __LINE__); \
 } while (0)
#elif defined(ALEWIFE)
#include <parallel.h>
#include <assert.h>
#else
#include <assert.h>
#endif

#include "crl.h"

unsigned crl_self_addr;
unsigned crl_num_nodes;


void crl_init(void)
{
#if defined(CM5)
  assert(CMMD_partition_size() == 1);
#elif defined(ALEWIFE)
  assert(NPROCS == 1);
#endif

  crl_self_addr = 0;
  crl_num_nodes = 1;
}


rid_t rgn_create(unsigned size)
{
  char *rslt;

  rslt = (char *) malloc(size + 8);
  assert(rslt != NULL);
  *((unsigned *) rslt) = size;

  return (rid_t) (rslt + 8);
}
