/*
 * top.h
 * kirk johnson
 * march 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: top.h,v 1.8 1995/08/24 08:23:38 tuna Exp $
 */

#ifndef _TOP_H_
#define _TOP_H_

#define USE_CRL
/*#define USE_REDUCTION*/
/*#define STATISTICS*/

#define RANDOM_FILE "/home/crl/working/apps/water/random.in"
#define INPUT_FILE  "/home/crl/working/apps/water/input.512"

#if defined(CM5)
#include <cm/cmmd.h>
#define assert(x)                                  \
 do {                                              \
  if (!(x))                                        \
    CMMD_error("pn %d: failed assertion, %s:%d\n", \
               crl_self_addr, __FILE__, __LINE__); \
 } while (0)
#elif defined(ALEWIFE)
#include <parallel.h>
#include <assert.h>
#else
#include <assert.h>
#endif

#if defined(USE_CRL)
#include "crl.h"
#else
/* if not CRL, assume Alewife SM; include stuff to get beng-hong lim's
 * funky reactive locks and #define safe_malloc to be plain ol' malloc
 */
#include <synch/locks/reactive.h>
#define safe_malloc(x) malloc(x)
#endif

extern void timer_clear_and_start(void);
extern void timer_stop_and_print(void);

#if !defined(USE_CRL)
extern void   shm_sync_seq_init(void);
extern void   shm_sync_par_init(void);
extern void   shm_barrier(void);
extern void   shm_bcast_send_p(void *);
extern void  *shm_bcast_recv_p(void);
extern double shm_reduce_dmin(double);
extern double shm_reduce_dmax(double);
extern double shm_reduce_dadd(double);
#endif

#endif
