/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*  Modifications of the original Barnes-Hut code (as taken from         */
/*  Stanford's SPLASH-2 distribution) to allow use on Alewife and        */
/*  with CRL are copyright:                                              */
/*                                                                       */
/*  Copyright (C) 1995 Massachusetts Institute of Technology             */
/*                                                                       */
/*************************************************************************/

#include "top.h"

#include "stdio.h"
#include "parameters.h"
#include "mdvar.h"
#include "water.h"
#include "wwpot.h"
#include "cnst.h"
#include "mddata.h"
#include "fileio.h"
#include "split.h"
#include "global.h"

/************************************************************************/
double  MDMAIN(NFSV,NFRST,NSTEP,NRST,NPRINT,NSAVE,LKT,NORD1,ProcID)
  
  /* routine that implements the time-steps. Called by main routine 
     and calls others */
  
  int NFSV,NFRST,NSTEP,NRST,NPRINT,NSAVE,LKT,NORD1;
  unsigned ProcID;
  
{
    double XTT;
    int i;
    double POTA,POTR,POTRF;
    double XVIR,AVGT,TEN;
    double TTMV = 0.0, TKIN = 0.0, TVIR = 0.0;
    
    /*.......ESTIMATE ACCELERATION FROM F/M */
    INTRAF(ProcID);

#if defined(USE_CRL)    
    rgn_barrier();
#else
    shm_barrier();
#endif
    
    INTERF(ACC,ProcID);

#if defined(USE_CRL)
    rgn_barrier();
#else
    shm_barrier();
#endif
    
    /* MOLECULAR DYNAMICS LOOP OVER ALL TIME-STEPS */
    
    for (i=1;i <= NSTEP; i++) {

	timer_clear_and_start();

#if defined(USE_CRL) && defined(STATISTICS)
	/* reset statistics at the start of 2nd iteration
	 */
	if (i == 2)
	{
	  if (crl_self_addr == 0)
	    printf("\n[reseting statistics]\n\n");
	  crl_stats_reset();
	}
#endif

        TTMV=TTMV+1.00;
        
        /* reset simulator stats at beginning of second time-step */
        
        /* POSSIBLE ENHANCEMENT:  Here's where one start measurements to avoid 
           cold-start effects.  Recommended to do this at the beginning of the
           second timestep; i.e. if (i == 2).
           */
        
#if defined(USE_REDUCTION)
        /* initialize local copies of shared sums */
        {
	  int dir;

	  VIR_g->val   = 0.0;

	  POT_g->POTA  = 0.0;
	  POT_g->POTR  = 0.0;
	  POT_g->POTRF = 0.0;

	  for (dir = XDIR; dir <= ZDIR; dir++)
	    SUM_g->val[dir] = 0.0;
	}
#else
        /* initialize various shared sums */
        if (ProcID == 0) {
            int dir;

#if defined(USE_CRL)
	    rgn_start_write(VIR_g);
#endif
	    VIR_g->val = 0.0;
#if defined(USE_CRL)
	    rgn_end_write(VIR_g);	
#endif

#if defined(USE_CRL)
	    rgn_start_write(POT_g);
#endif
	    POT_g->POTA  = 0.0;
	    POT_g->POTR  = 0.0;
	    POT_g->POTRF = 0.0;
#if defined(USE_CRL)
	    rgn_end_write(POT_g);	
#endif

#if defined(USE_CRL)
	    rgn_start_write(SUM_g);	
#endif
            for (dir = XDIR; dir <= ZDIR; dir++)
		SUM_g->val[dir] = 0.0;
#if defined(USE_CRL)
	    rgn_end_write(SUM_g);	
#endif
        }
#endif

	/* this barrier doesn't exist in the SPLASH version; it exists
	 * to ensure that VIR_g has been initialized before it gets
	 * used in INTRAF() [not that this was ever likely a problem,
	 * given the likely running time of PREDIC(), but just in
	 * case.]
	 */
#if defined(USE_CRL)
	rgn_barrier();
#else
	shm_barrier();
#endif
        
        PREDIC(TLC,NORD1,ProcID);
        INTRAF(ProcID);

#if defined(USE_CRL)
	rgn_barrier();
#else
	shm_barrier();
#endif
        
        INTERF(FORCES,ProcID);
        
        CORREC(PCC,NORD1,ProcID);
        
        BNDRY(ProcID);
        
        KINETI(NMOL,HMAS,OMAS,ProcID);

#if defined(USE_CRL)
	rgn_barrier();
#else
	shm_barrier();
#endif
        
#if defined(USE_CRL) && !defined(USE_REDUCTION)
	rgn_start_read(SUM_g);
#endif
        TKIN=TKIN + SUM_g->val[0] + SUM_g->val[1] + SUM_g->val[2];
#if defined(USE_CRL) && !defined(USE_REDUCTION)
	rgn_end_read(SUM_g);	
#endif

#if defined(USE_CRL) && !defined(USE_REDUCTION)
	rgn_start_read(VIR_g);
#endif
        TVIR=TVIR - VIR_g->val;
#if defined(USE_CRL) && !defined(USE_REDUCTION)
	rgn_end_read(VIR_g);	
#endif

        timer_stop_and_print();

#if defined(USE_CRL) && defined(STATISTICS)
	/* print statistics at the end of 3rd iteration
	 */
	if (i == 3)
	  crl_stats_print();
#endif

        /*  check if potential energy is to be computed, and if
            printing and/or saving is to be done, this time step.
            Note that potential energy is computed once every NPRINT
            time-steps */
        
        if (((i % NPRINT) == 0) || ( (NSAVE > 0) && ((i % NSAVE) == 0))){
            
            /*  call potential energy computing routine */
            POTENG(ProcID);

#if defined(USE_CRL)
	    rgn_barrier();
#else
	    shm_barrier();
#endif

#if defined(USE_CRL) && !defined(USE_REDUCTION)
	    rgn_start_read(POT_g);
#endif
	    POTA  = POT_g->POTA * FPOT;
	    POTR  = POT_g->POTR * FPOT;
	    POTRF = POT_g->POTRF * FPOT;
#if defined(USE_CRL) && !defined(USE_REDUCTION)
	    rgn_end_read(POT_g);	
#endif
            
            /* compute some values to print */
            XVIR=TVIR*FPOT*0.50/TTMV;
            AVGT=TKIN*FKIN*TEMP*2.00/(3.00*TTMV);

#if defined(USE_CRL) && !defined(USE_REDUCTION)
	    rgn_start_read(SUM_g);
#endif
            TEN=(SUM_g->val[0] + SUM_g->val[1] + SUM_g->val[2])*FKIN;
#if defined(USE_CRL) && !defined(USE_REDUCTION)
	    rgn_end_read(SUM_g);	
#endif

	    XTT=POTA+POTR+POTRF+TEN;
            
            if (ProcID == 0) {
                fprintf(six,"     %5d %14.5lf %12.5lf %12.5lf  \
                %12.5lf\n %16.3lf %16.5lf %16.5lf\n",
                        i,TEN,POTA,POTR,POTRF,XTT,AVGT,XVIR);
            }
        }
        
        /* wait for everyone to finish time-step */
#if defined(USE_CRL)
	rgn_barrier();
#else
	shm_barrier();
#endif
            
    } /* for i */
    
    return(XTT);
    
} /* end of subroutine MDMAIN */
