/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*  Modifications of the original Barnes-Hut code (as taken from         */
/*  Stanford's SPLASH-2 distribution) to allow use on Alewife and        */
/*  with CRL are copyright:                                              */
/*                                                                       */
/*  Copyright (C) 1995 Massachusetts Institute of Technology             */
/*                                                                       */
/*************************************************************************/

#include "top.h"
#include "math.h"
#include "mdvar.h"
#include "parameters.h"
#include "mddata.h"
#include "split.h"
#include "global.h"

KINETI(NMOL,HMAS,OMAS,ProcID)
  int NMOL;
  double HMAS,OMAS;
  unsigned ProcID;
  
  /* this routine computes kinetic energy in each of the three
     spatial dimensions, and puts the computed values in the
     SUM array */ 
{
    int dir, mol;
    double S;
    
    /* loop over the three directions */
    for (dir = XDIR; dir <= ZDIR; dir++) {
        S=0.0;
        /* loop over the molecules */
        for (mol = StartMol[ProcID]; mol < StartMol[ProcID+1]; mol++) {
            double *tempptr;

#if defined(USE_CRL)
	    rgn_start_read(VAR[mol]);
#endif

	    tempptr = VAR[mol]->F[VEL][dir]; 
            S += ( tempptr[H1] * tempptr[H1] +
                  tempptr[H2] * tempptr[H2] ) * HMAS
                      + (tempptr[O] * tempptr[O]) * OMAS;

#if defined(USE_CRL)
	    rgn_end_read(VAR[mol]);	
#endif

        }
#if defined(USE_CRL) && defined(USE_REDUCTION)
	SUM_g->val[dir] += rgn_reduce_dadd(S);
#elif defined(USE_CRL)
	rgn_start_write(SUM_g);
	SUM_g->val[dir] += S;
	rgn_end_write(SUM_g);
#elif defined(USE_REDUCTION)
	SUM_g->val[dir] += shm_reduce_dadd(S);
#else
	acquire_lock(&(SUM_g->lock));
	SUM_g->val[dir] += S;
	release_lock(&(SUM_g->lock));
#endif
    } /* for */
} /* end of subroutine KINETI */

