/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*  Modifications of the original Barnes-Hut code (as taken from         */
/*  Stanford's SPLASH-2 distribution) to allow use on Alewife and        */
/*  with CRL are copyright:                                              */
/*                                                                       */
/*  Copyright (C) 1995 Massachusetts Institute of Technology             */
/*                                                                       */
/*************************************************************************/

/*  This file contains the declaration of the GlobalMemory 
structure and the maximum number of molecules allowed 
by the program. */

#define MAXLCKS	4096

typedef struct
{
  double val[3];
#if !defined(USE_CRL)
  lock_t lock;
#endif
} SUM_struct;

typedef struct
{
  double POTA;
  double POTR;
  double POTRF;
#if !defined(USE_CRL)
  lock_t lock;
#endif
} POT_struct;

typedef struct
{
  double val;
#if !defined(USE_CRL)
  lock_t lock;
#endif
} VIR_struct;

#if defined(USE_CRL) && !defined(USE_REDUCTION)
rid_t SUM_rid;
rid_t POT_rid;
rid_t VIR_rid;
#endif

SUM_struct *SUM_g;
POT_struct *POT_g;
VIR_struct *VIR_g;
