/*
 * linreg.h
 * kirk johnson
 * february 1995
 *
 * Copyright (C) 1995 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation. The author makes no
 * representations about the suitability of this software for any
 * purpose. It is provided "as is" without express or implied
 * warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * RCS $Id: linreg.h,v 1.3 1995/08/22 21:27:49 tuna Exp $
 */

#ifndef _LINREG_H_
#define _LINREG_H_

typedef struct
{
  double b0_val;	/* intercept */
  double b0_std;
  double b1_val;	/* slope */
  double b1_std;
  double sst;		/* sum-of-squares, total      */
  double sse;		/* sum-of-squares, error      */
  double ssr;		/* sum-of-squares, regression */
} LinReg;

void linear_regression(int, double *, double *, LinReg *);

#endif
