/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*  Modifications of the original Barnes-Hut code (as taken from         */
/*  Stanford's SPLASH-2 distribution) to allow use on Alewife and        */
/*  with CRL are copyright:                                              */
/*                                                                       */
/*  Copyright (C) 1995 Massachusetts Institute of Technology             */
/*                                                                       */
/*************************************************************************/

#include "code.h"

int Child_Sequence[NUM_DIRECTIONS][NSUB] =
{
  { 2, 5, 6, 1, 0, 3, 4, 7},  /* BRC_FUC */
  { 2, 5, 6, 1, 0, 7, 4, 3},  /* BRC_FRA */
  { 1, 6, 5, 2, 3, 0, 7, 4},  /* BRA_FDA */
  { 1, 6, 5, 2, 3, 4, 7, 0},  /* BRA_FRC */
  { 6, 1, 2, 5, 4, 7, 0, 3},  /* BLC_FDC */
  { 6, 1, 2, 5, 4, 3, 0, 7},  /* BLC_FLA */
  { 5, 2, 1, 6, 7, 4, 3, 0},  /* BLA_FUA */
  { 5, 2, 1, 6, 7, 0, 3, 4},  /* BLA_FLC */
  { 1, 2, 5, 6, 7, 4, 3, 0},  /* BUC_FUA */
  { 1, 2, 5, 6, 7, 0, 3, 4},  /* BUC_FLC */
  { 6, 5, 2, 1, 0, 3, 4, 7},  /* BUA_FUC */
  { 6, 5, 2, 1, 0, 7, 4, 3},  /* BUA_FRA */
  { 5, 6, 1, 2, 3, 0, 7, 4},  /* BDC_FDA */
  { 5, 6, 1, 2, 3, 4, 7, 0},  /* BDC_FRC */
  { 2, 1, 6, 5, 4, 7, 0, 3},  /* BDA_FDC */
  { 2, 1, 6, 5, 4, 3, 0, 7},  /* BDA_FLA */

  { 3, 4, 7, 0, 1, 2, 5, 6},  /* FRC_BUC */
  { 3, 4, 7, 0, 1, 6, 5, 2},  /* FRC_BRA */
  { 0, 7, 4, 3, 2, 1, 6, 5},  /* FRA_BDA */
  { 0, 7, 4, 3, 2, 5, 6, 1},  /* FRA_BRC */
  { 7, 0, 3, 4, 5, 6, 1, 2},  /* FLC_BDC */
  { 7, 0, 3, 4, 5, 2, 1, 6},  /* FLC_BLA */
  { 4, 3, 0, 7, 6, 5, 2, 1},  /* FLA_BUA */
  { 4, 3, 0, 7, 6, 1, 2, 5},  /* FLA_BLC */
  { 0, 3, 4, 7, 6, 5, 2, 1},  /* FUC_BUA */
  { 0, 3, 4, 7, 6, 1, 2, 5},  /* FUC_BLC */
  { 7, 4, 3, 0, 1, 2, 5, 6},  /* FUA_BUC */
  { 7, 4, 3, 0, 1, 6, 5, 2},  /* FUA_BRA */
  { 4, 7, 0, 3, 2, 1, 6, 5},  /* FDC_BDA */
  { 4, 7, 0, 3, 2, 5, 6, 1},  /* FDC_BRC */
  { 3, 0, 7, 4, 5, 6, 1, 2},  /* FDA_BDC */
  { 3, 0, 7, 4, 5, 2, 1, 6},  /* FDA_BLA */
};

int Direction_Sequence[NUM_DIRECTIONS][NSUB] =
{
  { FRC_BUC, BRA_FRC, FDA_BDC, BLA_FUA, BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA },
 /* BRC_FUC */
  { FRC_BUC, BRA_FRC, FDA_BDC, BLA_FUA, BRA_FDA, FRC_BRA, BUC_FUA, FLC_BDC },
 /* BRC_FRA */
  { FRA_BDA, BRC_FRA, FUC_BUA, BLC_FDC, BDA_FLA, FDC_BDA, BRC_FRA, FUC_BLC },
 /* BRA_FDA */
  { FRA_BDA, BRC_FRA, FUC_BUA, BLC_FDC, BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA },
 /* BRA_FRC */
  { FLC_BDC, BLA_FLC, FUA_BUC, BRA_FDA, BDC_FRC, FDA_BDC, BLA_FLC, FUA_BRA },
 /* BLC_FDC */
  { FLC_BDC, BLA_FLC, FUA_BUC, BRA_FDA, BLA_FUA, FLC_BLA, BDC_FDA, FRC_BUC },
 /* BLC_FLA */
  { FLA_BUA, BLC_FLA, FDC_BDA, BRC_FUC, BUA_FRA, FUC_BUA, BLC_FLA, FDC_BRC },
 /* BLA_FUA */
  { FLA_BUA, BLC_FLA, FDC_BDA, BRC_FUC, BLC_FDC, FLA_BLC, BUA_FUC, FRA_BDA },
 /* BLA_FLC */
  { FUC_BLC, BUA_FUC, FRA_BRC, BDA_FLA, BUA_FRA, FUC_BUA, BLC_FLA, FDC_BRC },
 /* BUC_FUA */
  { FUC_BLC, BUA_FUC, FRA_BRC, BDA_FLA, BLC_FDC, FLA_BLC, BUA_FUC, FRA_BDA },
 /* BUC_FLC */
  { FUA_BRA, BUC_FUA, FLC_BLA, BDC_FRC, BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA },
 /* BUA_FUC */
  { FUA_BRA, BUC_FUA, FLC_BLA, BDC_FRC, BRA_FDA, FRC_BRA, BUC_FUA, FLC_BDC },
 /* BUA_FRA */
  { FDC_BRC, BDA_FDC, FLA_BLC, BUA_FRA, BDA_FLA, FDC_BDA, BRC_FRA, FUC_BLC },
 /* BDC_FDA */
  { FDC_BRC, BDA_FDC, FLA_BLC, BUA_FRA, BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA },
 /* BDC_FRC */
  { FDA_BLA, BDC_FDA, FRC_BRA, BUC_FLC, BDC_FRC, FDA_BDC, BLA_FLC, FUA_BRA },
 /* BDA_FDC */
  { FDA_BLA, BDC_FDA, FRC_BRA, BUC_FLC, BLA_FUA, FLC_BLA, BDC_FDA, FRC_BUC },
 /* BDA_FLA */

  { BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA, FUC_BLC, BUA_FUC, FRA_BRC, BDA_FLA },
 /* FRC_BUC */
  { BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA, FRA_BDA, BRC_FRA, FUC_BUA, BLC_FDC },
 /* FRC_BRA */
  { BRA_FDA, FRC_BRA, BUC_FUA, FLC_BDC, FDA_BLA, BDC_FDA, FRC_BRA, BUC_FLC },
 /* FRA_BDA */
  { BRA_FDA, FRC_BRA, BUC_FUA, FLC_BDC, FRC_BUC, BRA_FRC, FDA_BDC, BLA_FUA },
 /* FRA_BRC */
  { BLC_FDC, FLA_BLC, BUA_FUC, FRA_BDA, FDC_BRC, BDA_FDC, FLA_BLC, BUA_FRA },
 /* FLC_BDC */
  { BLC_FDC, FLA_BLC, BUA_FUC, FRA_BDA, FLA_BUA, BLC_FLA, FDC_BDA, BRC_FUC },
 /* FLC_BLA */
  { BLA_FUA, FLC_BLA, BDC_FDA, FRC_BUC, FUA_BRA, BUC_FUA, FLC_BLA, BDC_FRC },
 /* FLA_BUA */
  { BLA_FUA, FLC_BLA, BDC_FDA, FRC_BUC, FLC_BDC, BLA_FLC, FUA_BUC, BRA_FDA },
 /* FLA_BLC */
  { BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA, FUA_BRA, BUC_FUA, FLC_BLA, BDC_FRC },
 /* FUC_BUA */
  { BUC_FLC, FUA_BUC, BRA_FRC, FDA_BLA, FLC_BDC, BLA_FLC, FUA_BUC, BRA_FDA },
 /* FUC_BLC */
  { BUA_FRA, FUC_BUA, BLC_FLA, FDC_BRC, FUC_BLC, BUA_FUC, FRA_BRC, BDA_FLA },
 /* FUA_BUC */
  { BUA_FRA, FUC_BUA, BLC_FLA, FDC_BRC, FRA_BDA, BRC_FRA, FUC_BUA, BLC_FDC },
 /* FUA_BRA */
  { BDC_FRC, FDA_BDC, BLA_FLC, FUA_BRA, FDA_BLA, BDC_FDA, FRC_BRA, BUC_FLC },
 /* FDC_BDA */
  { BDC_FRC, FDA_BDC, BLA_FLC, FUA_BRA, FRC_BUC, BRA_FRC, FDA_BDC, BLA_FUA },
 /* FDC_BRC */
  { BDA_FLA, FDC_BDA, BRC_FRA, FUC_BLC, FDC_BRC, BDA_FDC, FLA_BLC, BUA_FRA },
 /* FDA_BDC */
  { BDA_FLA, FDC_BDA, BRC_FRA, FUC_BLC, FLA_BUA, BLC_FLA, FDC_BDA, BRC_FUC },
 /* FDA_BLA */
};
