/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/* --------------------------------------------------------------------- */
/*                                                                       */
/*  Modifications of the original Barnes-Hut code (as taken from         */
/*  Stanford's SPLASH-2 distribution) to allow use on Alewife and        */
/*  with CRL are copyright:                                              */
/*                                                                       */
/*  Copyright (C) 1995 Massachusetts Institute of Technology             */
/*                                                                       */
/*************************************************************************/

/*
 * CODE.H: define various global things for CODE.C.
 */

#ifndef _CODE_H_
#define _CODE_H_

#define USE_CRL

#include "defs.h"

/* parameters */
extern real dtime; 		/* timestep for leapfrog integrator */
extern real dtout; 		/* time between data outputs */
extern real tstop; 		/* time to stop calculation */
extern int  nbody; 		/* number of bodies in system */
extern real fcells; 		/* ratio of cells/leaves allocated */
extern real fleaves; 		/* ratio of leaves/bodies allocated */
extern real tol; 		/* accuracy parameter: 0.0 => exact */
extern real tolsq; 		/* square of previous */
extern real eps; 		/* potential softening parameter */
extern real epssq; 		/* square of previous */
extern real dthf; 		/* half time step */

extern int      maxcell;	/* max number of cells allocated */
extern int      maxleaf;	/* max number of leaves allocated */
extern int      maxmybody;	/* max no. of bodies allocated per processor */
extern int      maxmycell;	/* max num. of cells to be allocated */
extern int      maxmyleaf;	/* max num. of leaves to be allocated */
#if defined(USE_CRL)
extern rid_t   *bodytab; /* array size is exactly nbody bodies */
#else
extern bodyptr *bodytab;
#endif
extern cellptr  g_root;		/* global tree root */
extern vector   rmin;		/* lower-left corner of coordinate box */
extern real     rsize;		/* side-length of integer coordinate box */

struct GlobalMemory		/* all this info is for the whole system */
{
  int     n2bcalc;		/* total number of body/cell interactions  */
  int     nbccalc;		/* total number of body/body interactions  */
  int     selfint;		/* number of self interactions             */
  real    mtot;			/* total mass of N-body system             */
  real    etot[3];		/* binding, kinetic, potential energy      */
  matrix  keten;		/* kinetic energy tensor                   */
  matrix  peten;		/* potential energy tensor                 */
  vector  cmphase[2];		/* center of mass coordinates and velocity */
  vector  amvec;		/* angular momentum vector                 */
#if !defined(USE_CRL)
  lock_t  CountLock;		/* Lock on the shared variables            */
#endif
};

extern struct GlobalMemory *Global;

struct LocalMemory
{
  real tnow;		/* current value of simulation time */
  real tout;		/* time next output is due */
  int  nstep;		/* number of integration steps so far */

  int workMin;		/* interval of cost to be treated by a proc */
  int workMax;

  vector min;		/* min and max of coordinates for each proc */
  vector max;

  int      mynumcell;	/* num. of cells used for this proc in ctab */
  int      mynumleaf;	/* num. of leaves used for this proc in ctab */
  int      mynbody;	/* num bodies allocated to the processor */
#if defined(USE_CRL)
  rid_t   *mybodytab;	/* array of bodies allocated / processor */
#else
  bodyptr *mybodytab;
#endif
  int      myncell;	/* num cells allocated to the processor */
#if defined(USE_CRL)
  rid_t   *mycelltab;	/* array of cellptrs allocated to the processor */
#else
  cellptr *mycelltab;
#endif
  int      mynleaf;	/* number of leaves allocated to the processor */
#if defined(USE_CRL)
  rid_t   *myleaftab;	/* array of leafptrs allocated to the processor */
  rid_t   *ctab;	/* array of cells used for the tree */
  rid_t   *ltab;	/* array of cells used for the tree */
#else
  leafptr *myleaftab;	/* array of leafptrs allocated to the processor */
  cellptr  ctab;	/* array of cells used for the tree */
  leafptr  ltab;	/* array of cells used for the tree */
#endif

  int     myn2bcalc;	/* body-body force calculations for each processor */
  int     mynbccalc;	/* body-cell force calculations for each processor */
  int     myselfint;	/* count self-interactions for each processor */
  int     myn2bterm;	/* count body-body terms for a body */
  int     mynbcterm;	/* count body-cell terms for a body */
  bool    skipself;	/* true if self-interaction skipped OK */
  bodyptr pskip;	/* body to skip in force evaluation */
  vector  pos0;		/* point at which to evaluate field */
  real    phi0;		/* computed potential at pos0 */
  vector  acc0;		/* computed acceleration at pos0 */
  vector  dr;		/* data to be shared */
  real    drsq;		/* between gravsub and subdivp */
  nodeptr pmem;		/* remember particle data */

  real   mymtot;	/* total mass of N-body system */
  real   myetot[3];	/* binding, kinetic, potential energy */
  matrix myketen;	/* kinetic energy tensor */
  matrix mypeten;	/* potential energy tensor */
  vector mycmphase[2];	/* center of mass coordinates */
  vector myamvec;	/* angular momentum vector */
};

extern struct LocalMemory Local;

/* code.c
 */
#if !defined(USE_CRL)
extern void   shm_sync_seq_init(void);
extern void   shm_sync_par_init(void);
extern void   shm_barrier(void);
extern void   shm_bcast_send_p(void *);
extern void  *shm_bcast_recv_p(void);
extern double shm_reduce_dmin(double);
extern double shm_reduce_dmax(double);
extern double shm_reduce_dadd(double);
#endif

/* code_io.c
 */
extern void initoutput(void);

/* grav.c
 */
extern void hackgrav(bodyptr, unsigned);

/* load.c
 */
extern void maketree(unsigned);

/* util.c
 */
extern void pranset(int);

#endif
