//----------------------------------*-C++-*----------------------------------//
// tstString.cc
// Geoffrey Furnish
// 28 January 1994
//---------------------------------------------------------------------------//
// @> Program to test the String class.
//
// $Id: tstString.cc,v 1.4 1995/06/19 18:39:23 furnish Exp $
//
// $Log: tstString.cc,v $
// Revision 1.4  1995/06/19  18:39:23  furnish
// Some silliness for testing operator const char *().  Needed to expose
// a shlib linking problem on Linux, where the DS++ and the libg++ String
// classes were getting intercombobulated.
//
// Revision 1.3  1994/12/06  19:25:09  furnish
// ANSI WP doesn't like aggregates to introduce varargs.
//
// Revision 1.2  1994/05/18  21:55:01  furnish
// Shut up main() warnings on some compilers.  Need to think about this
// more.  Add stdarg processing test to help document bug in Lucid and
// ObjectCenter regarding stdarg processing with String& anchors.
//
// Revision 1.1  1994/02/01  19:23:28  furnish
// Some test programs for shaking down the ds++ class library.
//
//---------------------------------------------------------------------------//

#include "String.h"		// Don't use <> so dependency analyzer
				// will pick up the stuff we're trying
				// to test!

#include <iostream.h>

#include <stdarg.h>

void test_stdarg( const char *s, ... );

void test_cast( const char *s, const char *t = "r" )
{
    cout << "test_cast received:" << s << ":.\n" << flush;
}

main()
{
    String a = "a";
    String b;
    String c(a);

    a += "bcd";
    b += a;
    c = a + " x " + b;

    String d = c;

    test_cast( d );

    d = a;

    cout << "a = " << a << endl;
    cout << "b = " << b << endl;
    cout << "c = " << c << endl;
    cout << "d = " << d << endl;

    test_stdarg( "Bzzzzzzzzzzt", 1, 2, 3, 4. );
}

void test_stdarg( const char *s, ... )
{
    cout << "test_stdarg:: s == " << s << endl;

    va_list ap;
    va_start(ap,s);

    int a1 = va_arg(ap,int);
    int a2 = va_arg(ap,int);
    int a3 = va_arg(ap,int);
    float a4 = va_arg(ap,float);

    cout << "arg1 = " << a1 << endl;
    cout << "arg2 = " << a2 << endl;
    cout << "arg3 = " << a3 << endl;
    cout << "arg4 = " << a4 << endl;

    cout << "Done testing stdarg processing.\n";
}

//---------------------------------------------------------------------------//
//                              end of tstString.cc
//---------------------------------------------------------------------------//
