//----------------------------------*-C++-*----------------------------------//
// tstMap.cc
// Geoffrey Furnish
// 17 June 1994
//---------------------------------------------------------------------------//
// @> Program to test the Map<K,V> class.
//
// $Id: tstMap.cc,v 1.6 1995/09/16 17:04:53 furnish Exp $
//
// $Log: tstMap.cc,v $
// Revision 1.6  1995/09/16  17:04:53  furnish
// Upgrade to new iterator semantics.
//
// Revision 1.5  1994/12/06  19:27:03  furnish
// Assert.h now in DS++.
//
// Revision 1.4  1994/06/23  05:38:25  furnish
// Fix boundary handling problem, reimplement test case to be useful.
//
// Revision 1.3  1994/06/17  20:16:06  furnish
// Completely reimplemented the test case to perform a better check of
// the Map's functionality.  Needs further embellishement though.
//
//---------------------------------------------------------------------------//

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>

#include "String.h"
#include "Map.h"

#include "Assert.h"

int main( int argc, char *argv[] )
{
    int violations = 0;

    Map<String,int> msi;
    msi[ "one" ] = 1;
    msi[ "two" ] = 2;
    msi[ "three" ] = 3;

    if (msi[ "two"] != 2) violations++;

    Map_iter<String,int> msii(msi);

    if ( msii.key() != "one" ) violations++;
    msii++;
    if ( msii.value() != 3 ) violations++;
    if ( (++msii).key() != "two" ) violations++;
    if ( msii.value() != 2 ) violations++;

    const Map<String,int> cmsi(msi);

    try {
	int four = cmsi[ "four" ];
	violations++;
    } catch( const char *s ) {
	cout << "Good, caught the bogus access exception.\n";
    } catch(...) {
	cerr << "Unknown exception occurred.\n";
	violations++;
    }

    msi.remove( "three" );
    if ( msi["one"] != 1 ) violations++;
    if ( msi["two"] != 2 ) violations++;

    msi.remove( "two" );
    
    //msi.remove( "twentynine" );

    cout << "Violations : " << violations << endl;
    return violations;
}

//---------------------------------------------------------------------------//
//                              end of tstMap.cc
//---------------------------------------------------------------------------//
