//----------------------------------*-C++-*----------------------------------//
// Stack.h
// Geoffrey Furnish
// 28 January 1994
//---------------------------------------------------------------------------//
// @> A Stack template class.
//
// $Id: Stack.h,v 1.3 1994/12/02 17:46:19 furnish Exp $
//
// $Log: Stack.h,v $
// Revision 1.3  1994/12/02  17:46:19  furnish
// Formatting, documentation.  Switch from codoc to autodoc.
//
// Revision 1.2  1994/04/20  22:05:52  furnish
// Syntax error which was never caught until instantiation.
//
// Revision 1.1  1994/02/08  19:29:26  furnish
// A templated stack class.
//
//---------------------------------------------------------------------------//

#ifndef __Stack_h__
#define __Stack_h__

#include "DynArray.h"

//===========================================================================//
// class Stack<T> - A templated unbounded stack class

// This class provides the classic stack data structure.  It is templated so
// it is typesafe, and a stack can be made to hold any type of C++ object.
//
// The stack is implemented using the DS++ DynArray<T> class, so it is
// unbounded in size.  The stack is value oriented, so pushing and popping
// will result in the copy constructor for the contained object being called.
// Client classes should be robust to this sort of usage.
//===========================================================================//

template<class T>
class Stack {

    DynArray<T> stk;
    int top;

  public:
    Stack() : top(0), stk(10) {}

    void push( const T& a );
    T pop();

};

#endif				// __Stack_h__

//---------------------------------------------------------------------------//
//                              end of Stack.h
//---------------------------------------------------------------------------//
