//----------------------------------*-C++-*----------------------------------//
// Stack.cc
// Geoffrey Furnish
// 28 January 1994
//---------------------------------------------------------------------------//
// @> A Stack template class.
//
// $Id: Stack.cc,v 1.4 1994/12/06 19:27:00 furnish Exp $
//
// $Log: Stack.cc,v $
// Revision 1.4  1994/12/06  19:27:00  furnish
// Assert.h now in DS++.
//
// Revision 1.3  1994/12/02  17:46:17  furnish
// Formatting, documentation.  Switch from codoc to autodoc.
//
// Revision 1.2  1994/07/29  15:58:09  furnish
// Some cleaning/robustification.  Needs more work.
//
// Revision 1.1  1994/02/08  19:29:25  furnish
// A templated stack class.
//
//---------------------------------------------------------------------------//

#include "Stack.h"
#include "Assert.h"

//---------------------------------------------------------------------------//
// Push a value onto the stack.  This is done by copying the argument.
//---------------------------------------------------------------------------//

template<class T>
void Stack<T>::push( const T& a )
{
    stk[ ++top ] = a;
}

//---------------------------------------------------------------------------//
// Pop a value off the stack.  Again, value semantics.
//---------------------------------------------------------------------------//

template<class T>
T Stack<T>::pop()
{
    Insist( top, "Stack underflow" );

    return stk[ top-- ];
}

//---------------------------------------------------------------------------//
//                              end of Stack.cc
//---------------------------------------------------------------------------//
