//----------------------------------*-C++-*----------------------------------//
// tstSArray.cc
// Geoffrey Furnish
// Wed Feb  1 11:45:44 1995
//---------------------------------------------------------------------------//
// @> Program to test operation of the SArray<T> class.
//
// $Id: tstSArray.cc,v 1.5 1995/11/11 01:48:56 furnish Exp $
//
// $Log: tstSArray.cc,v $
// Revision 1.5  1995/11/11  01:48:56  furnish
// IBM style template instantiation.
//
// Revision 1.4  1995/10/13  19:55:47  furnish
// Instantiations for SGI/PGI.
//
// Revision 1.3  1995/06/13  21:19:02  furnish
// More careful preinstantiation.
//
// Revision 1.2  1995/04/27  15:45:27  furnish
// Prevent spurious manpage generation for silly test classes.
//
// Revision 1.1  1995/02/10  19:57:19  furnish
// New test case.
//
//---------------------------------------------------------------------------//

#include <iostream.h>
#include "SArray.h"

void test_dtor();

main()
{
    test_dtor();
}

// autodoc: noprint foo

//---------------------------------------------------------------------------//
// A quickie test to make sure destructors are called for Arrays of objects.
//---------------------------------------------------------------------------//

class foo {
  public:
    foo() { cout << "A foo is constructed.\n"; }
    ~foo() { cout << "A foo is destructed.\n"; }
};

#if defined(__sgi) || defined(__PGI)
#include "SArray.cc"
#pragma instantiate SArray<foo>
#endif

#ifdef __GNUC__
#include "SArray.cc"
template class SArray<foo>;
#endif

#ifdef _POWER
#include "SArray.cc"
#pragma define ( SArray<foo> )
#endif

void test_dtor()
{
    SArray<foo> x(5);
}

//---------------------------------------------------------------------------//
//                              end of tstSArray.cc
//---------------------------------------------------------------------------//

