//----------------------------------*-C++-*----------------------------------//
// tstList.cc
// Geoffrey Furnish
// 17 January 1994
//---------------------------------------------------------------------------//
// @> Program to test various list classes.
//
// $Id: tstList.cc,v 1.9 1995/10/13 19:56:24 furnish Exp $
//
// $Log: tstList.cc,v $
// Revision 1.9  1995/10/13  19:56:24  furnish
// PGI won't allow a variable decl in the condition of a for loop.  I
// guess that seems reasonable, but I hadn't encountered it before.
//
// Revision 1.8  1995/09/16  17:04:52  furnish
// Upgrade to new iterator semantics.
//
// Revision 1.7  1995/04/27  16:01:46  furnish
// Typo, grrrr.
//
// Revision 1.6  1995/04/27  15:45:26  furnish
// Prevent spurious manpage generation for silly test classes.
//
// Revision 1.5  1994/12/06  19:25:42  furnish
// Preinstantiate for GCC 2.6+.
//
// Revision 1.4  1994/05/18  21:54:15  furnish
// Shut up main() warnings on some compilers.  Need to think about this
// more.
//
// Revision 1.3  1994/04/20  22:07:59  furnish
// New tests to find bugs which don't exist :-).
//
// Revision 1.2  1994/02/08  19:26:16  furnish
// Convert to new iterator syntax.
//
// Revision 1.1  1994/02/01  19:23:26  furnish
// Some test programs for shaking down the ds++ class library.
//
//---------------------------------------------------------------------------//

#include "List.h"		// Don't use <> so dependency analyzer
				// will pick up the stuff we're trying
				// to test!

#include <iostream.h>
#include "String.h"

// autodoc: noprint name

class name : public slink {
  public:
    String n;

    name( const String& _n ) : slink(), n(_n) {}
};

#ifdef __GNUC__
template class Islist<name>;
template class Islist_iter<name>;
template class Tlink<int>;
template class Slist<int>;
template class Slist_iter<int>;
template class Tlink<int *>;
template class Slist<int *>;
template class Slist_iter<int *>;
#endif

main()
{
// Tests of the slist_base class.

    slist_base slb1;
    slb1.insert( new name("Bubba") );
    name *p = (name *) slb1.get();

    cout << "Pulled name " << p->n << " off the list.\n";
    delete p;

// Tests of the Islist class

    Islist<name> is1;

    is1.insert( new name("Bruno") );
    name *p2 = is1.get();

    cout << "Pulled name " << p2->n << " off the list.\n";
    delete p2;

#define ADD(a) is2.insert( new name(a) );

    Islist<name> is2;
    ADD("one");
    ADD("two");
    ADD("three");
    ADD("four");
    ADD("five");
    ADD("six");
    ADD("seven");
    ADD("eight");

    Islist_iter<name> iter2(is2);

    {
	name *pn = iter2();
	cout << "first one on the list is " << pn->n << endl;
	iter2++;
	pn = iter2();
	if (pn)
	    cout << "second one on the list is " << pn->n << endl;
    }

    cout << "The names of the numbers are:\n";
    name *pn;
    for( iter2.reset(); pn = iter2(); iter2++ )
	cout << pn->n << endl << flush;

    {
    // Tests of the Slist class

	cout << "\n\n Now testing Slist<T> class.\n\n";

	Slist<int> li;

	for( int i=-10; i <= 10; i++ )
	    li.append(i);

	cout << "The numbers are:\n";

	int x;
	for( Slist_iter<int> sii(li); x = sii(); sii++ )
	    cout << x << endl;
    }

// Okay, now test list copying and so forth.

    int i;
    int *vi = new int[ 100 ];
    for( i=0; i < 100; i++ )
	vi[i] = i;

    Slist<int *> pintlist;

    for( i=0; i < 100; i++ )
	pintlist.append( &vi[i] );

// Okay, now lets check that we can read this list.

    i = 0;
    for( Slist_iter<int *> ipi( pintlist ); ipi; ipi++ ) {
 	int *px = ipi();
	cout << i << ':' << *px << "  ";
	if ( ++i == 10 )
	    i = 0, cout << endl;
    }

// Now check copying of lists and so forth.

    Slist<int *> pintl2 = pintlist;
    
    i = 0;
    for( Slist_iter<int *> ipi2( pintl2 ); ipi2; ipi2++ ) {
	int *px = ipi2();
	cout << i << ':' << *px << "  ";
	if ( ++i == 10 )
	    i = 0, cout << endl;
    }

    void dump( Slist<int *>& );

    dump( pintl2 );
}

void dump( Slist<int *>& pil )
{
    cout << "\n\n Dumping an Slist<int *>:\n";
    int i = 0;
    for( Slist_iter<int *> ipil( pil ); ipil; ipil++ ) {
	int *px = ipil();
	cout << i << ':' << *px << "  ";
	if ( ++i == 10 )
	    i = 0, cout << endl;
    }
}

//---------------------------------------------------------------------------//
//                              end of tstList.cc
//---------------------------------------------------------------------------//
