//----------------------------------*-C++-*----------------------------------//
// tstDynTable.cc
// Geoffrey Furnish
// Tue Jan 24 11:56:42 1995
//---------------------------------------------------------------------------//
// @> Test program for the DynTable<T> class.
//
// $Id: tstDynTable.cc,v 1.2 1995/07/20 17:25:43 lindberg Exp $
//
// $Log: tstDynTable.cc,v $
// Revision 1.2  1995/07/20  17:25:43  lindberg
// Tests for the added methods.
//
// Revision 1.1  1995/01/24  18:31:56  furnish
// New templated class for handling dynamic tables of data.
//
//---------------------------------------------------------------------------//

#include "DynTable.h"
#include "Assert.h"
#include <iostream.h>

main()
{
    DynTable<char> dt;

    dt(0,0) = 'a';
    dt(0,1) = 'b';
    dt(0,2) = 'c';

    dt(1,0) = 'd';
    dt(1,1) = 'e';
    dt(1,2) = 'f';
    dt(1,3) = 'g';

    dt(2,0) = 'h';
    dt(2,1) = 'i';

    DynTable<char> dup = dt;

    Assert( dup(0,0) == 'a' );
    Assert( dup(0,1) == 'b' );
    Assert( dup(0,2) == 'c' );

    Assert( dup(1,0) == 'd' );
    Assert( dup(1,1) == 'e' );
    Assert( dup(1,2) == 'f' );
    Assert( dup(1,3) == 'g' );

    Assert( dup(2,0) == 'h' );
    Assert( dup(2,1) == 'i' );

    int row_low = dup.low_row();
    int row_high = dup.high_row();
    Assert( row_low == 0 );
    Assert( row_high == 2 );

    int row, column;
    for (row = row_low; row <= row_high; row++) {
      cout << "Column low and high for row " << row << " are "
	   << dup.low_column(row) << " and " << dup.high_column(row) << endl;
      for (column = dup.low_column(row); column <= dup.high_column(row);
	   column++ ) {
	cout << "dup(" << row << "," << column << ") = " << dup(row,column)
	     << endl;
      }
    }

    cout << "\nDeleting row\n";
    dup.delete_row(1);
    row_low = dup.low_row();
    row_high = dup.high_row();
    cout << "New row low and high are " << row_low << "  "
	 << row_high << endl;
    for (row = row_low; row <= row_high; row++) {
      cout << "Column low and high for row " << row << " are "
	   << dup.low_column(row) << " and " << dup.high_column(row) << endl;
      for (column = dup.low_column(row); column <= dup.high_column(row);
	   column++ ) {
	cout << "dup(" << row << "," << column << ") = " << dup(row,column)
	     << endl;
      }
    }

//  Delete an illegal row
//    dup.delete_row(10);

    cout << "\nInserting another point\n";
    dup(0,3) = 'd';
    dup(0,4) = 'e';
    for (row = row_low; row <= row_high; row++) {
      cout << "Column low and high for row " << row << " are "
	   << dup.low_column(row) << " and " << dup.high_column(row) << endl;
      for (column = dup.low_column(row); column <= dup.high_column(row);
	   column++ ) {
	cout << "dup(" << row << "," << column << ") = " << dup(row,column)
	     << endl;
      }
    }

// Delete a column range
    cout << "\nDeleting a column range\n";
    dup.del_col_range(0,3,5);
    for (row = row_low; row <= row_high; row++) {
      cout << "Column low and high for row " << row << " are "
	   << dup.low_column(row) << " and " << dup.high_column(row) << endl;
      for (column = dup.low_column(row); column <= dup.high_column(row);
	   column++ ) {
	cout << "dup(" << row << "," << column << ") = " << dup(row,column)
	     << endl;
      }
    }
}

//---------------------------------------------------------------------------//
//                              end of tstDynTable.cc
//---------------------------------------------------------------------------//

