//----------------------------------*-C++-*----------------------------------//
// slist.h
// Geoffrey Furnish
// 16 January 1994
//---------------------------------------------------------------------------//
// @> Stroustrup's slist family (2nd ed, chapter 8).
//
// $Id: slist.h,v 1.5 1995/09/16 17:04:15 furnish Exp $
//
// $Log: slist.h,v $
// Revision 1.5  1995/09/16  17:04:15  furnish
// Convert all list variants away from auto-incrementation behavior, and
// standardize on the explicit increment mode which was already in use
// with the SPlist.  All DS++ list and map classes now support uniform
// naming and operation conventions.
//
// Revision 1.4  1995/06/13  21:18:39  furnish
// Support resetting of list iterators.
//
// Revision 1.3  1994/02/15  19:39:31  furnish
// Formatting.
//
// Revision 1.2  1994/02/08  19:25:49  furnish
// Fix the iterator so it works...
//
// Revision 1.1  1994/02/01  19:22:34  furnish
// Stroustrup's slist helper classes for Islist and Slist.
//
//---------------------------------------------------------------------------//

#ifndef __slist_h__
#define __slist_h__

struct slink {
    slink *next;

// Do I need these?  Are they ever getting used?
    slink() { next = 0; }
    slink( slink *p ) { next = p; }
};

class slist_base {
    slink *last;		// last->next is head of list.

  public:
    slist_base() { last = 0; }
    slist_base( slink *a ) { last = a->next = a; }

    void insert( slink *a );	// add at head of list.
    void append( slink *a );	// add at tail of list.
    slink *get();		// remove and return head of list.

    void clear() { last = 0; }

    friend class slist_base_iter;
};

class slist_base_iter {
    slink *ce;			// current element,
    slist_base* slb;		// of this list.

  public:
    slist_base_iter( slist_base& s )
    {
	slb = &s;
	reset();
    }

    operator void *()   { return ce; }
    slink *operator()() { return ce; }

    void reset() 
    {
	if (slb->last)
	// If the list has at least one element, set ce to head of list.
	    ce = slb->last->next;
	else
	// Otherwise, clear the current element.
	    ce = 0;
    }

    void operator++()
    {
	if (ce == slb->last) {
	// If this is the last element, then the "next" one doesn't exist.
	    ce = 0;
	} else if (ce) {
	// If we are currently on an existent element (but not the last one),
	// then move to the next one.
	    ce = ce->next;
	}
    }
};    

#endif				// __slist_h__

//---------------------------------------------------------------------------//
//                              end of slist.h
//---------------------------------------------------------------------------//
